/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.arquillian;

import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ToIntFunction;
import org.wildfly.clustering.arquillian.RelativeURIBuilder;

public interface URIBuilder
extends RelativeURIBuilder {
    public URIBuilder setScheme(String var1);

    public URIBuilder setUserInfo(String var1);

    public URIBuilder setHost(String var1);

    public URIBuilder setPort(int var1);

    @Override
    default public URIBuilder addPath(String path) {
        return this.addPath(path, Map.of());
    }

    @Override
    public URIBuilder addPath(String var1, Map<String, String> var2);

    @Override
    default public URIBuilder addParameter(String parameterName, String parameterValue) {
        return this.addParameter(parameterName, parameterValue);
    }

    @Override
    default public URIBuilder addParameters(Map<String, String> parameters) {
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            this.addParameter(parameter.getKey(), parameter.getValue());
        }
        return this;
    }

    @Override
    public URIBuilder setFragment(String var1);

    public static URIBuilder of() {
        return URIBuilder.of(new ToIntFunction<String>(){

            @Override
            public int applyAsInt(String scheme) {
                return switch (scheme) {
                    case "ftp" -> 21;
                    case "sftp" -> 22;
                    case "scp" -> 22;
                    case "ssh" -> 22;
                    case "dns" -> 53;
                    case "http" -> 80;
                    case "https" -> 443;
                    default -> throw new IllegalArgumentException(scheme);
                };
            }
        });
    }

    public static URIBuilder of(final ToIntFunction<String> defaultPort) {
        final AtomicReference<String> schemeRef = new AtomicReference<String>("http");
        final AtomicReference userInfoRef = new AtomicReference();
        final AtomicReference<String> hostRef = new AtomicReference<String>(InetAddress.getLoopbackAddress().getHostName());
        final AtomicReference<OptionalInt> portRef = new AtomicReference<OptionalInt>(OptionalInt.empty());
        final LinkedList paths = new LinkedList();
        final TreeMap parameters = new TreeMap();
        final AtomicReference fragmentRef = new AtomicReference();
        return new URIBuilder(){

            @Override
            public URIBuilder setScheme(String value) {
                schemeRef.setPlain(value);
                return this;
            }

            @Override
            public URIBuilder setUserInfo(String userInfo) {
                userInfoRef.setPlain(userInfo);
                return this;
            }

            @Override
            public URIBuilder setHost(String host) {
                hostRef.setPlain(host);
                return this;
            }

            @Override
            public URIBuilder setPort(int port) {
                portRef.setPlain(OptionalInt.of(port));
                return this;
            }

            @Override
            public URIBuilder addPath(String path, Map<String, String> parameters2) {
                StringBuilder builder = new StringBuilder(path);
                if (!parameters2.isEmpty()) {
                    for (Map.Entry<String, String> parameter : parameters2.entrySet()) {
                        builder.append(";").append(parameter.getKey()).append("=").append(parameter.getValue());
                    }
                }
                paths.add(builder.toString());
                return this;
            }

            @Override
            public URIBuilder addParameter(String name, String value) {
                parameters.computeIfAbsent(name, key -> new LinkedList()).add(value);
                return this;
            }

            @Override
            public URIBuilder setFragment(String fragment) {
                fragmentRef.setPlain(fragment);
                return this;
            }

            @Override
            public URI build() {
                LinkedList<CallSite> queryParameters;
                String scheme = (String)schemeRef.getPlain();
                String userInfo = (String)userInfoRef.getPlain();
                String host = (String)hostRef.getPlain();
                int port = ((OptionalInt)portRef.getPlain()).orElseGet(() -> defaultPort.applyAsInt(scheme));
                StringBuilder builder = new StringBuilder();
                for (String path : paths) {
                    if (!path.startsWith("/")) {
                        builder.append("/");
                    }
                    builder.append(path);
                }
                String path = !builder.isEmpty() ? builder.toString() : null;
                LinkedList<CallSite> linkedList = queryParameters = !parameters.isEmpty() ? new LinkedList<CallSite>() : List.of();
                if (!parameters.isEmpty()) {
                    for (Map.Entry entry : parameters.entrySet()) {
                        for (String value : (List)entry.getValue()) {
                            queryParameters.add((CallSite)((Object)((String)entry.getKey() + "=" + Optional.ofNullable(value).orElse(""))));
                        }
                    }
                }
                String query = !parameters.isEmpty() ? String.join((CharSequence)"&", queryParameters) : null;
                String fragment = (String)fragmentRef.getPlain();
                try {
                    return new URI(scheme, userInfo, host, port, path, query, fragment);
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }
}

