/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.batch;

import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.logging.Logger;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.BatchContext;
import org.wildfly.clustering.cache.batch.Batcher;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;
import org.wildfly.clustering.cache.infinispan.batch.TransactionalBatch;

public class TransactionalBatcher<E extends RuntimeException>
implements Batcher<TransactionBatch> {
    private static final TransactionBatch NON_TX_BATCH = new TransactionBatch(){

        public void close() {
        }

        public void discard() {
        }

        public Batch.State getState() {
            return Batch.State.ACTIVE;
        }

        @Override
        public Transaction getTransaction() {
            return null;
        }

        @Override
        public TransactionBatch interpose() {
            return this;
        }
    };
    private static final BatchContext<TransactionBatch> NON_TX_BATCH_CONTEXT = new BatchContext<TransactionBatch>(){

        public TransactionBatch getBatch() {
            return NON_TX_BATCH;
        }

        public void close() {
        }
    };
    private static final ThreadLocal<TransactionBatch> CURRENT_BATCH = new ThreadLocal();
    private static final Synchronization CURRENT_BATCH_SYNCHRONIZATION = new Synchronization(){

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            TransactionalBatcher.setCurrentBatch(null);
        }
    };
    private final Logger logger;
    private final TransactionManager tm;
    private final Function<Throwable, E> exceptionTransformer;

    static TransactionBatch getCurrentBatch() {
        return CURRENT_BATCH.get();
    }

    static void setCurrentBatch(TransactionBatch batch) {
        if (batch != null) {
            CURRENT_BATCH.set(batch);
        } else {
            CURRENT_BATCH.remove();
        }
    }

    public TransactionalBatcher(String name, TransactionManager tm, Function<Throwable, E> exceptionTransformer) {
        this.logger = Logger.getLogger(this.getClass(), (String)name);
        this.tm = tm;
        this.exceptionTransformer = exceptionTransformer;
    }

    public TransactionBatch createBatch() {
        if (this.tm == null) {
            return NON_TX_BATCH;
        }
        TransactionalBatch<E> batch = TransactionalBatcher.getCurrentBatch();
        try {
            if (batch != null && batch.isActive()) {
                return batch.interpose();
            }
            Transaction suspendedTx = this.tm.suspend();
            if (suspendedTx != null && suspendedTx.getStatus() != 6) {
                throw new IllegalStateException(suspendedTx.toString());
            }
            this.tm.begin();
            Transaction tx = this.tm.getTransaction();
            tx.registerSynchronization(CURRENT_BATCH_SYNCHRONIZATION);
            batch = new TransactionalBatch<E>(tx, this.logger, this.exceptionTransformer);
            TransactionalBatcher.setCurrentBatch(batch);
            return batch;
        }
        catch (NotSupportedException | RollbackException | SystemException e) {
            throw (RuntimeException)this.exceptionTransformer.apply(e);
        }
    }

    public BatchContext<TransactionBatch> resumeBatch(TransactionBatch batch) {
        TransactionBatch resumingBatch;
        TransactionBatch suspendingBatch = TransactionalBatcher.getCurrentBatch();
        return suspendingBatch != (resumingBatch = (TransactionBatch)Optional.ofNullable(batch).filter(Predicate.not(Batch::isClosed)).orElse(null)) ? new TransactionalBatchContext(suspendingBatch, resumingBatch) : NON_TX_BATCH_CONTEXT;
    }

    public TransactionBatch suspendBatch() {
        if (this.tm == null) {
            return NON_TX_BATCH;
        }
        TransactionBatch batch = TransactionalBatcher.getCurrentBatch();
        if (batch != null) {
            try {
                Transaction tx = this.tm.suspend();
                if (batch.getTransaction() != tx) {
                    throw new IllegalStateException();
                }
            }
            catch (SystemException e) {
                throw (RuntimeException)this.exceptionTransformer.apply(e);
            }
            finally {
                TransactionalBatcher.setCurrentBatch(null);
            }
        }
        return Optional.ofNullable(batch).filter(Predicate.not(Batch::isClosed)).orElse(NON_TX_BATCH);
    }

    private class TransactionalBatchContext
    implements BatchContext<TransactionBatch> {
        private final TransactionManager tm;
        private final Function<Throwable, E> exceptionTransformer;
        private final TransactionBatch suspendedBatch;
        private final TransactionBatch resumedBatch;

        TransactionalBatchContext(TransactionBatch suspendingBatch, TransactionBatch resumingBatch) {
            Transaction resumingTx;
            Transaction suspendingTx;
            this.tm = TransactionalBatcher.this.tm;
            this.exceptionTransformer = TransactionalBatcher.this.exceptionTransformer;
            Transaction transaction = suspendingTx = suspendingBatch != null ? suspendingBatch.getTransaction() : null;
            if (suspendingTx != null) {
                try {
                    if (this.tm.suspend() != suspendingTx) {
                        throw new IllegalStateException();
                    }
                }
                catch (SystemException e) {
                    throw (RuntimeException)this.exceptionTransformer.apply(e);
                }
            }
            Transaction transaction2 = resumingTx = resumingBatch != null ? resumingBatch.getTransaction() : null;
            if (resumingTx != null) {
                try {
                    this.tm.resume(resumingTx);
                }
                catch (InvalidTransactionException | SystemException e) {
                    throw (RuntimeException)this.exceptionTransformer.apply(e);
                }
            }
            this.suspendedBatch = suspendingBatch;
            this.resumedBatch = resumingBatch;
            TransactionalBatcher.setCurrentBatch(resumingBatch);
        }

        public TransactionBatch getBatch() {
            return Optional.ofNullable(TransactionalBatcher.getCurrentBatch()).orElse(NON_TX_BATCH);
        }

        public void close() {
            Transaction suspendedTx;
            Transaction resumedTx;
            Transaction transaction = resumedTx = this.resumedBatch != null ? this.resumedBatch.getTransaction() : null;
            if (resumedTx != null) {
                try {
                    suspendedTx = this.tm.suspend();
                    if (suspendedTx != null && suspendedTx != resumedTx) {
                        throw new IllegalStateException();
                    }
                }
                catch (SystemException e) {
                    throw (RuntimeException)this.exceptionTransformer.apply(e);
                }
            }
            Transaction transaction2 = suspendedTx = this.suspendedBatch != null ? this.suspendedBatch.getTransaction() : null;
            if (suspendedTx != null) {
                try {
                    this.tm.resume(suspendedTx);
                }
                catch (InvalidTransactionException | SystemException e) {
                    throw (RuntimeException)this.exceptionTransformer.apply(e);
                }
            }
            TransactionalBatcher.setCurrentBatch(this.suspendedBatch);
        }
    }
}

