/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.batch;

import jakarta.transaction.Synchronization;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.BatchContext;
import org.wildfly.clustering.cache.batch.Batcher;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;
import org.wildfly.clustering.cache.infinispan.batch.TransactionalBatcher;

public class TransactionalBatcherTestCase {
    private final TransactionManager tm = (TransactionManager)Mockito.mock(TransactionManager.class);
    private final Batcher<TransactionBatch> batcher = new TransactionalBatcher("test", this.tm, RuntimeException::new);

    @AfterEach
    public void destroy() {
        TransactionalBatcher.setCurrentBatch(null);
    }

    private static TransactionBatch mockBatch() {
        TransactionBatch batch = (TransactionBatch)Mockito.mock(TransactionBatch.class);
        ((TransactionBatch)Mockito.doCallRealMethod().when((Object)batch)).isActive();
        ((TransactionBatch)Mockito.doCallRealMethod().when((Object)batch)).isDiscarded();
        ((TransactionBatch)Mockito.doCallRealMethod().when((Object)batch)).isClosed();
        return batch;
    }

    @Test
    public void createExistingActiveBatch() throws Exception {
        TransactionBatch existingBatch = TransactionalBatcherTestCase.mockBatch();
        TransactionalBatcher.setCurrentBatch((TransactionBatch)existingBatch);
        ((TransactionBatch)Mockito.doReturn((Object)Batch.State.ACTIVE).when((Object)existingBatch)).getState();
        ((TransactionBatch)Mockito.doReturn((Object)existingBatch).when((Object)existingBatch)).interpose();
        TransactionBatch result = (TransactionBatch)this.batcher.createBatch();
        ((TransactionBatch)Mockito.verify((Object)existingBatch)).interpose();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.tm});
        Assertions.assertSame((Object)existingBatch, (Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createExistingClosedBatch() throws Exception {
        TransactionBatch existingBatch = TransactionalBatcherTestCase.mockBatch();
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        TransactionalBatcher.setCurrentBatch((TransactionBatch)existingBatch);
        ((TransactionBatch)Mockito.doReturn((Object)Batch.State.CLOSED).when((Object)existingBatch)).getState();
        ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
        try (TransactionBatch batch = (TransactionBatch)this.batcher.createBatch();){
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
            Assertions.assertSame((Object)tx, (Object)batch.getTransaction());
            Assertions.assertSame((Object)batch, (Object)TransactionalBatcher.getCurrentBatch());
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(3);
        }
        ((Transaction)Mockito.verify((Object)tx)).commit();
        Assertions.assertNull((Object)TransactionalBatcher.getCurrentBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createBatchClose() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
        try (TransactionBatch batch = (TransactionBatch)this.batcher.createBatch();){
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
            Assertions.assertSame((Object)tx, (Object)batch.getTransaction());
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(3);
        }
        ((Transaction)Mockito.verify((Object)tx)).commit();
        Assertions.assertNull((Object)TransactionalBatcher.getCurrentBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createBatchDiscard() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
        try (TransactionBatch batch = (TransactionBatch)this.batcher.createBatch();){
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
            Assertions.assertSame((Object)tx, (Object)batch.getTransaction());
            batch.discard();
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(4);
        }
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
        ((Transaction)Mockito.verify((Object)tx)).rollback();
        Assertions.assertNull((Object)TransactionalBatcher.getCurrentBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createNestedBatchClose() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
        try (TransactionBatch outerBatch = (TransactionBatch)this.batcher.createBatch();){
            Assertions.assertSame((Object)tx, (Object)outerBatch.getTransaction());
            ((TransactionManager)Mockito.verify((Object)this.tm)).suspend();
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
            try (TransactionBatch innerBatch = (TransactionBatch)this.batcher.createBatch();){
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)1))).suspend();
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)1))).begin();
            }
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).rollback();
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(3);
        }
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).rollback();
        ((Transaction)Mockito.verify((Object)tx)).commit();
        Assertions.assertNull((Object)TransactionalBatcher.getCurrentBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createNestedBatchDiscard() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
        try (TransactionBatch outerBatch = (TransactionBatch)this.batcher.createBatch();){
            ((TransactionManager)Mockito.verify((Object)this.tm)).suspend();
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
            Assertions.assertSame((Object)tx, (Object)outerBatch.getTransaction());
            ((Transaction)Mockito.doReturn((Object)0).when((Object)tx)).getStatus();
            ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
            try (TransactionBatch innerBatch = (TransactionBatch)this.batcher.createBatch();){
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)1))).suspend();
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)1))).begin();
                innerBatch.discard();
            }
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).rollback();
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(4);
        }
        ((Transaction)Mockito.verify((Object)tx)).rollback();
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
        Assertions.assertNull((Object)TransactionalBatcher.getCurrentBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createOverlappingBatchClose() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
        TransactionBatch batch = (TransactionBatch)this.batcher.createBatch();
        ((TransactionManager)Mockito.verify((Object)this.tm)).suspend();
        ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
        ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
        try {
            Assertions.assertSame((Object)tx, (Object)batch.getTransaction());
            ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
            ((Transaction)Mockito.doReturn((Object)0).when((Object)tx)).getStatus();
            try (TransactionBatch innerBatch = (TransactionBatch)this.batcher.createBatch();){
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)1))).suspend();
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)1))).begin();
                batch.close();
                ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).rollback();
                ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
            }
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(3);
        }
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).rollback();
        ((Transaction)Mockito.verify((Object)tx)).commit();
        Assertions.assertNull((Object)TransactionalBatcher.getCurrentBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createOverlappingBatchDiscard() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
        TransactionBatch batch = (TransactionBatch)this.batcher.createBatch();
        ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
        ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
        try {
            Assertions.assertSame((Object)tx, (Object)batch.getTransaction());
            ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
            ((Transaction)Mockito.doReturn((Object)0).when((Object)tx)).getStatus();
            try (TransactionBatch innerBatch = (TransactionBatch)this.batcher.createBatch();){
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)1))).suspend();
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)1))).begin();
                innerBatch.discard();
                batch.close();
                ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
                ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).rollback();
            }
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(4);
        }
        ((Transaction)Mockito.verify((Object)tx)).rollback();
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
        Assertions.assertNull((Object)TransactionalBatcher.getCurrentBatch());
    }

    @Test
    public void resumeNullBatch() throws Exception {
        TransactionBatch batch = TransactionalBatcherTestCase.mockBatch();
        TransactionalBatcher.setCurrentBatch((TransactionBatch)batch);
        try (BatchContext context = this.batcher.resumeBatch(null);){
            Mockito.verifyNoInteractions((Object[])new Object[]{this.tm});
            Assertions.assertNull((Object)TransactionalBatcher.getCurrentBatch());
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{this.tm});
        Assertions.assertSame((Object)batch, (Object)TransactionalBatcher.getCurrentBatch());
    }

    @Test
    public void resumeClosedBatch() throws Exception {
        TransactionBatch existingBatch = TransactionalBatcherTestCase.mockBatch();
        TransactionalBatcher.setCurrentBatch((TransactionBatch)existingBatch);
        TransactionBatch batch = TransactionalBatcherTestCase.mockBatch();
        ((TransactionBatch)Mockito.doReturn((Object)Batch.State.CLOSED).when((Object)batch)).getState();
        try (BatchContext context = this.batcher.resumeBatch((Batch)batch);){
            Mockito.verifyNoInteractions((Object[])new Object[]{this.tm});
            Assertions.assertNull((Object)TransactionalBatcher.getCurrentBatch());
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{this.tm});
        Assertions.assertSame((Object)existingBatch, (Object)TransactionalBatcher.getCurrentBatch());
    }

    @Test
    public void resumeNonTxBatch() throws Exception {
        TransactionBatch existingBatch = TransactionalBatcherTestCase.mockBatch();
        TransactionalBatcher.setCurrentBatch((TransactionBatch)existingBatch);
        TransactionBatch batch = TransactionalBatcherTestCase.mockBatch();
        try (BatchContext context = this.batcher.resumeBatch((Batch)batch);){
            Mockito.verifyNoInteractions((Object[])new Object[]{this.tm});
            Assertions.assertSame((Object)batch, (Object)TransactionalBatcher.getCurrentBatch());
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{this.tm});
        Assertions.assertSame((Object)existingBatch, (Object)TransactionalBatcher.getCurrentBatch());
    }

    @Test
    public void resumeBatch() throws Exception {
        TransactionBatch batch = TransactionalBatcherTestCase.mockBatch();
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        TransactionalBatcher.setCurrentBatch(null);
        ((TransactionBatch)Mockito.doReturn((Object)tx).when((Object)batch)).getTransaction();
        ((TransactionBatch)Mockito.doReturn((Object)Batch.State.ACTIVE).when((Object)batch)).getState();
        ((TransactionManager)Mockito.doReturn(null).when((Object)this.tm)).suspend();
        try (BatchContext context = this.batcher.resumeBatch((Batch)batch);){
            Assertions.assertSame((Object)batch, (Object)TransactionalBatcher.getCurrentBatch());
            ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.never())).suspend();
            ((TransactionManager)Mockito.verify((Object)this.tm)).resume(tx);
            ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).suspend();
        }
        ((TransactionManager)Mockito.verify((Object)this.tm)).suspend();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Assertions.assertNull((Object)TransactionalBatcher.getCurrentBatch());
    }

    @Test
    public void resumeBatchExisting() throws Exception {
        TransactionBatch existingBatch = TransactionalBatcherTestCase.mockBatch();
        Transaction existingTx = (Transaction)Mockito.mock(Transaction.class);
        TransactionalBatcher.setCurrentBatch((TransactionBatch)existingBatch);
        TransactionBatch batch = TransactionalBatcherTestCase.mockBatch();
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ((TransactionBatch)Mockito.doReturn((Object)existingTx).when((Object)existingBatch)).getTransaction();
        ((TransactionBatch)Mockito.doReturn((Object)Batch.State.ACTIVE).when((Object)existingBatch)).getState();
        ((TransactionBatch)Mockito.doReturn((Object)tx).when((Object)batch)).getTransaction();
        ((TransactionBatch)Mockito.doReturn((Object)Batch.State.ACTIVE).when((Object)batch)).getState();
        ((TransactionManager)Mockito.doReturn((Object)existingTx).when((Object)this.tm)).suspend();
        try (BatchContext context = this.batcher.resumeBatch((Batch)batch);){
            ((TransactionManager)Mockito.verify((Object)this.tm)).resume(tx);
            Mockito.reset((Object[])new TransactionManager[]{this.tm});
            Assertions.assertSame((Object)batch, (Object)TransactionalBatcher.getCurrentBatch());
            Mockito.when((Object)this.tm.suspend()).thenReturn((Object)tx);
        }
        ((TransactionManager)Mockito.verify((Object)this.tm)).resume(existingTx);
        Assertions.assertSame((Object)existingBatch, (Object)TransactionalBatcher.getCurrentBatch());
    }

    @Test
    public void suspendBatch() throws Exception {
        TransactionBatch batch = TransactionalBatcherTestCase.mockBatch();
        TransactionalBatcher.setCurrentBatch((TransactionBatch)batch);
        TransactionBatch result = (TransactionBatch)this.batcher.suspendBatch();
        ((TransactionManager)Mockito.verify((Object)this.tm)).suspend();
        Assertions.assertSame((Object)batch, (Object)result);
        Assertions.assertNull((Object)TransactionalBatcher.getCurrentBatch());
    }

    @Test
    public void suspendNoBatch() throws Exception {
        TransactionalBatcher.setCurrentBatch(null);
        TransactionBatch result = (TransactionBatch)this.batcher.suspendBatch();
        ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.never())).suspend();
        Assertions.assertNotNull((Object)result);
        Assertions.assertNull((Object)result.getTransaction());
    }
}

