/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.batch;

import jakarta.transaction.Synchronization;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.BatchContext;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.cache.infinispan.batch.ThreadLocalTransactionBatch;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;

public class TransactionBatchTestCase {
    private final TransactionManager tm = (TransactionManager)Mockito.mock(TransactionManager.class);
    private final TransactionBatch.Factory factory = TransactionBatch.factory((String)"test", (TransactionManager)this.tm, RuntimeException::new);

    @AfterEach
    public void destroy() {
        ThreadLocalTransactionBatch.setCurrentBatch(null);
    }

    @Test
    public void createExistingActiveBatch() throws Exception {
        TransactionBatch existingBatch = (TransactionBatch)Mockito.mock(TransactionBatch.class);
        ThreadLocalTransactionBatch.setCurrentBatch((TransactionBatch)existingBatch);
        ((TransactionBatch)Mockito.doReturn((Object)true).when((Object)existingBatch)).isActive();
        ((TransactionBatch)Mockito.doReturn((Object)existingBatch).when((Object)existingBatch)).interpose();
        TransactionBatch result = this.factory.get();
        ((TransactionBatch)Mockito.verify((Object)existingBatch)).interpose();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.tm});
        Assertions.assertSame((Object)existingBatch, (Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createExistingClosedBatch() throws Exception {
        TransactionBatch existingBatch = (TransactionBatch)Mockito.mock(TransactionBatch.class);
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        ThreadLocalTransactionBatch.setCurrentBatch((TransactionBatch)existingBatch);
        ((TransactionBatch)Mockito.doReturn((Object)true).when((Object)existingBatch)).isClosed();
        ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
        try (TransactionBatch batch = this.factory.get();){
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
            Assertions.assertSame((Object)tx, (Object)batch.getTransaction());
            Assertions.assertSame((Object)batch, (Object)ThreadLocalTransactionBatch.getCurrentBatch());
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(3);
        }
        ((Transaction)Mockito.verify((Object)tx)).commit();
        Assertions.assertNull((Object)ThreadLocalTransactionBatch.getCurrentBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createBatchClose() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
        try (TransactionBatch batch = this.factory.get();){
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
            Assertions.assertSame((Object)tx, (Object)batch.getTransaction());
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(3);
        }
        ((Transaction)Mockito.verify((Object)tx)).commit();
        Assertions.assertNull((Object)ThreadLocalTransactionBatch.getCurrentBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createBatchDiscard() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
        try (TransactionBatch batch = this.factory.get();){
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
            Assertions.assertSame((Object)tx, (Object)batch.getTransaction());
            batch.discard();
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(4);
        }
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
        ((Transaction)Mockito.verify((Object)tx)).rollback();
        Assertions.assertNull((Object)ThreadLocalTransactionBatch.getCurrentBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createNestedBatchClose() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
        try (TransactionBatch outerBatch = this.factory.get();){
            Assertions.assertSame((Object)tx, (Object)outerBatch.getTransaction());
            ((TransactionManager)Mockito.verify((Object)this.tm)).suspend();
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
            try (TransactionBatch innerBatch = this.factory.get();){
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)1))).suspend();
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)1))).begin();
            }
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).rollback();
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(3);
        }
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).rollback();
        ((Transaction)Mockito.verify((Object)tx)).commit();
        Assertions.assertNull((Object)ThreadLocalTransactionBatch.getCurrentBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createNestedBatchDiscard() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
        try (TransactionBatch outerBatch = this.factory.get();){
            ((TransactionManager)Mockito.verify((Object)this.tm)).suspend();
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
            Assertions.assertSame((Object)tx, (Object)outerBatch.getTransaction());
            ((Transaction)Mockito.doReturn((Object)0).when((Object)tx)).getStatus();
            ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
            try (TransactionBatch innerBatch = this.factory.get();){
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)1))).suspend();
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)1))).begin();
                innerBatch.discard();
            }
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).rollback();
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(4);
        }
        ((Transaction)Mockito.verify((Object)tx)).rollback();
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
        Assertions.assertNull((Object)ThreadLocalTransactionBatch.getCurrentBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createOverlappingBatchClose() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
        TransactionBatch batch = this.factory.get();
        ((TransactionManager)Mockito.verify((Object)this.tm)).suspend();
        ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
        ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
        try {
            Assertions.assertSame((Object)tx, (Object)batch.getTransaction());
            ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
            ((Transaction)Mockito.doReturn((Object)0).when((Object)tx)).getStatus();
            try (TransactionBatch innerBatch = this.factory.get();){
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)1))).suspend();
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)1))).begin();
                batch.close();
                ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).rollback();
                ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
            }
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(3);
        }
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).rollback();
        ((Transaction)Mockito.verify((Object)tx)).commit();
        Assertions.assertNull((Object)ThreadLocalTransactionBatch.getCurrentBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createOverlappingBatchDiscard() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
        TransactionBatch batch = this.factory.get();
        ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
        ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
        try {
            Assertions.assertSame((Object)tx, (Object)batch.getTransaction());
            ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
            ((Transaction)Mockito.doReturn((Object)0).when((Object)tx)).getStatus();
            try (TransactionBatch innerBatch = this.factory.get();){
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)1))).suspend();
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)1))).begin();
                innerBatch.discard();
                batch.close();
                ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
                ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).rollback();
            }
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(4);
        }
        ((Transaction)Mockito.verify((Object)tx)).rollback();
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
        Assertions.assertNull((Object)ThreadLocalTransactionBatch.getCurrentBatch());
    }

    @Test
    public void suspendClosed() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor sync = ArgumentCaptor.captor((Object[])new Synchronization[0]);
        ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
        TransactionBatch batch = this.factory.get();
        ((TransactionManager)Mockito.verify((Object)this.tm)).suspend();
        ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
        ((TransactionManager)Mockito.verify((Object)this.tm)).getTransaction();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)sync.capture());
        Assertions.assertSame((Object)batch, (Object)ThreadLocalTransactionBatch.getCurrentBatch());
        Assertions.assertSame((Object)tx, (Object)batch.getTransaction());
        batch.close();
        ((Transaction)Mockito.verify((Object)tx)).commit();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        ((Synchronization)sync.getValue()).afterCompletion(3);
        Assertions.assertNull((Object)ThreadLocalTransactionBatch.getCurrentBatch());
        Assertions.assertNotSame((Object)batch, (Object)batch.suspend().resume());
    }

    @Test
    public void suspendResume() throws Exception {
        ArgumentCaptor sync = ArgumentCaptor.captor((Object[])new Synchronization[0]);
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
        ((TransactionManager)Mockito.doReturn(null, (Object[])new Object[]{tx}).when((Object)this.tm)).suspend();
        TransactionBatch batch = this.factory.get();
        ((TransactionManager)Mockito.verify((Object)this.tm)).suspend();
        ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
        ((TransactionManager)Mockito.verify((Object)this.tm)).getTransaction();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)sync.capture());
        Assertions.assertSame((Object)batch, (Object)ThreadLocalTransactionBatch.getCurrentBatch());
        Assertions.assertSame((Object)tx, (Object)batch.getTransaction());
        SuspendedBatch suspended = batch.suspend();
        ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)2))).suspend();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Assertions.assertNull((Object)ThreadLocalTransactionBatch.getCurrentBatch());
        Assertions.assertThrows(IllegalStateException.class, () -> ((TransactionBatch)batch).discard());
        Assertions.assertThrows(IllegalStateException.class, () -> ((TransactionBatch)batch).interpose());
        Assertions.assertThrows(IllegalStateException.class, () -> ((TransactionBatch)batch).close());
        Batch resumed = suspended.resume();
        ((TransactionManager)Mockito.verify((Object)this.tm)).resume(tx);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Assertions.assertSame((Object)batch, (Object)resumed);
        Assertions.assertSame((Object)resumed, (Object)ThreadLocalTransactionBatch.getCurrentBatch());
    }

    @Test
    public void suspendResumeClosed() throws Exception {
        ArgumentCaptor sync = ArgumentCaptor.captor((Object[])new Synchronization[0]);
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).getTransaction();
        ((TransactionManager)Mockito.doReturn(null, (Object[])new Object[]{tx, tx}).when((Object)this.tm)).suspend();
        TransactionBatch batch = this.factory.get();
        ((TransactionManager)Mockito.verify((Object)this.tm)).suspend();
        ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
        ((TransactionManager)Mockito.verify((Object)this.tm)).getTransaction();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)sync.capture());
        Assertions.assertSame((Object)batch, (Object)ThreadLocalTransactionBatch.getCurrentBatch());
        Assertions.assertSame((Object)tx, (Object)batch.getTransaction());
        SuspendedBatch suspended = batch.suspend();
        ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)2))).suspend();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Assertions.assertNull((Object)ThreadLocalTransactionBatch.getCurrentBatch());
        try (Batch resumed = suspended.resume();){
            ((TransactionManager)Mockito.verify((Object)this.tm)).resume(tx);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
            Assertions.assertSame((Object)batch, (Object)resumed);
            Assertions.assertSame((Object)resumed, (Object)ThreadLocalTransactionBatch.getCurrentBatch());
        }
        ((Transaction)Mockito.verify((Object)tx)).commit();
        ((Synchronization)sync.getValue()).afterCompletion(3);
        Assertions.assertNull((Object)ThreadLocalTransactionBatch.getCurrentBatch());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Assertions.assertNull((Object)ThreadLocalTransactionBatch.getCurrentBatch());
    }

    @Test
    public void suspendActiveResume() throws Exception {
        ArgumentCaptor sync1 = ArgumentCaptor.captor((Object[])new Synchronization[0]);
        ArgumentCaptor sync2 = ArgumentCaptor.captor((Object[])new Synchronization[0]);
        Transaction tx1 = (Transaction)Mockito.mock(Transaction.class, (String)"tx1");
        Transaction tx2 = (Transaction)Mockito.mock(Transaction.class, (String)"tx2");
        ((TransactionManager)Mockito.doReturn((Object)tx1, (Object[])new Object[]{tx2}).when((Object)this.tm)).getTransaction();
        ((TransactionManager)Mockito.doReturn(null, (Object[])new Object[]{tx1, null, tx2, tx1}).when((Object)this.tm)).suspend();
        TransactionBatch batch1 = this.factory.get();
        ((TransactionManager)Mockito.verify((Object)this.tm)).suspend();
        ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
        ((TransactionManager)Mockito.verify((Object)this.tm)).getTransaction();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        ((Transaction)Mockito.verify((Object)tx1)).registerSynchronization((Synchronization)sync1.capture());
        Assertions.assertSame((Object)batch1, (Object)ThreadLocalTransactionBatch.getCurrentBatch());
        Assertions.assertSame((Object)tx1, (Object)batch1.getTransaction());
        SuspendedBatch suspended = batch1.suspend();
        ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)2))).suspend();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Assertions.assertNull((Object)ThreadLocalTransactionBatch.getCurrentBatch());
        try (TransactionBatch batch2 = this.factory.get();){
            ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)3))).suspend();
            ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)2))).begin();
            ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)2))).getTransaction();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
            ((Transaction)Mockito.verify((Object)tx2)).registerSynchronization((Synchronization)sync2.capture());
            Assertions.assertSame((Object)batch2, (Object)ThreadLocalTransactionBatch.getCurrentBatch());
            Assertions.assertSame((Object)tx2, (Object)batch2.getTransaction());
            try (BatchContext context = suspended.resumeWithContext();){
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)4))).suspend();
                ((TransactionManager)Mockito.verify((Object)this.tm)).resume(tx1);
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
                try (Batch resumed = (Batch)context.get();){
                    Assertions.assertSame((Object)batch1, (Object)resumed);
                    Assertions.assertSame((Object)resumed, (Object)ThreadLocalTransactionBatch.getCurrentBatch());
                }
                ((Transaction)Mockito.verify((Object)tx1)).commit();
                ((Synchronization)sync1.getValue()).afterCompletion(3);
                Assertions.assertNull((Object)ThreadLocalTransactionBatch.getCurrentBatch());
            }
            ((TransactionManager)Mockito.verify((Object)this.tm)).resume(tx2);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
            Assertions.assertSame((Object)batch2, (Object)ThreadLocalTransactionBatch.getCurrentBatch());
        }
        ((Synchronization)sync2.getValue()).afterCompletion(3);
        Assertions.assertNull((Object)ThreadLocalTransactionBatch.getCurrentBatch());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
    }
}

