/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.batch;

import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.function.Function;
import java.util.function.Supplier;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.cache.infinispan.batch.ThreadLocalTransactionBatch;

public interface TransactionBatch
extends Batch,
SuspendedBatch {
    public Transaction getTransaction();

    public TransactionBatch interpose();

    public static <E extends RuntimeException> Factory factory(String name, final TransactionManager tm, final Function<Throwable, E> exceptionTransformer) {
        final System.Logger logger = System.getLogger(String.join((CharSequence)".", TransactionBatch.class.getName(), name));
        final Synchronization synchronization = new Synchronization(){

            public void beforeCompletion() {
            }

            public void afterCompletion(int status) {
                ThreadLocalTransactionBatch.setCurrentBatch(null);
            }
        };
        return new Factory(){

            @Override
            public TransactionBatch get() {
                ThreadLocalTransactionBatch batch = ThreadLocalTransactionBatch.getCurrentBatch();
                try {
                    if (batch != null && batch.isActive()) {
                        return batch.interpose();
                    }
                    Transaction suspendedTx = tm.suspend();
                    if (suspendedTx != null && suspendedTx.getStatus() != 6) {
                        throw new IllegalStateException(suspendedTx.toString());
                    }
                    tm.begin();
                    Transaction tx = tm.getTransaction();
                    tx.registerSynchronization(synchronization);
                    batch = new ThreadLocalTransactionBatch(tm, tx, logger, exceptionTransformer);
                    ThreadLocalTransactionBatch.setCurrentBatch(batch);
                    return batch;
                }
                catch (NotSupportedException | RollbackException | SystemException e) {
                    throw (RuntimeException)exceptionTransformer.apply(e);
                }
            }
        };
    }

    public static interface Factory
    extends Supplier<Batch> {
        @Override
        public TransactionBatch get();
    }
}

