/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.batch;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicInteger;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.infinispan.batch.ContextualBatch;
import org.wildfly.clustering.cache.infinispan.batch.ContextualException;
import org.wildfly.clustering.function.Consumer;

public abstract class AbstractContextualBatch
implements ContextualBatch {
    private final AtomicInteger count = new AtomicInteger(0);
    private final String name;
    private final StackTraceElement[] stackTrace;
    private final Consumer<Batch.Status> closeTask;

    AbstractContextualBatch(String name, Consumer<Batch.Status> closeTask) {
        this.name = name;
        PrivilegedAction<StackTraceElement[]> action = Thread.currentThread()::getStackTrace;
        this.stackTrace = LOGGER.isLoggable(System.Logger.Level.DEBUG) ? (System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run()) : null;
        this.closeTask = closeTask;
    }

    public ContextualBatch get() {
        if (this.getStatus().isClosed()) {
            throw new IllegalStateException(this.toString(), new ContextualException(this));
        }
        int count = this.count.incrementAndGet();
        LOGGER.log(System.Logger.Level.DEBUG, "Created child context {0}[{1}]", this, count);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void attach(Throwable exception) {
        if (this.stackTrace != null) {
            exception.setStackTrace(this.stackTrace);
        }
    }

    public void close() {
        int count = this.count.getAndDecrement();
        if (count == 0) {
            this.closeTask.accept((Object)this.getStatus());
        } else {
            LOGGER.log(System.Logger.Level.DEBUG, "Closed child context {0}[{1}]", this, count);
        }
    }
}

