/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.batch;

import jakarta.transaction.TransactionManager;
import java.util.function.Function;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.infinispan.batch.ContextualBatch;
import org.wildfly.clustering.cache.infinispan.batch.DefaultTransactionalBatch;
import org.wildfly.clustering.cache.infinispan.batch.ThreadContextBatch;
import org.wildfly.clustering.cache.infinispan.batch.TransactionalBatch;
import org.wildfly.clustering.function.Supplier;

public class TransactionalBatchFactory
implements Supplier<Batch> {
    private final String name;
    private final TransactionManager tm;
    private final Function<Exception, RuntimeException> exceptionTransformer;

    public TransactionalBatchFactory(String name, TransactionManager tm, Function<Exception, RuntimeException> exceptionTransformer) {
        this.name = name;
        this.tm = tm;
        this.exceptionTransformer = exceptionTransformer;
    }

    public Batch get() {
        TransactionalBatch batch = (TransactionalBatch)ThreadContextBatch.INSTANCE.get(TransactionalBatch.class);
        ThreadContextBatch.INSTANCE.accept(batch != null ? (ContextualBatch)batch.get() : new DefaultTransactionalBatch(this.name, this.tm, this.exceptionTransformer));
        return ThreadContextBatch.INSTANCE;
    }
}

