/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.batch;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.cache.infinispan.batch.ContextualBatch;
import org.wildfly.clustering.cache.infinispan.batch.ContextualSuspendedBatch;
import org.wildfly.clustering.cache.infinispan.batch.ThreadContextBatch;
import org.wildfly.clustering.context.Context;

public class ThreadContextBatchTestCase {
    @BeforeEach
    public void init() {
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
    }

    @AfterEach
    public void destroy() {
        ThreadContextBatch.INSTANCE.accept(null);
    }

    @Test
    public void getStatus() {
        ContextualBatch batch = (ContextualBatch)Mockito.mock(ContextualBatch.class);
        Batch.Status status = (Batch.Status)Mockito.mock(Batch.Status.class);
        ThreadContextBatch.INSTANCE.accept(batch);
        Mockito.verifyNoInteractions((Object[])new Object[]{batch});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isSameAs((Object)batch);
        ((ContextualBatch)Mockito.doReturn((Object)status).when((Object)batch)).getStatus();
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.getStatus()).isSameAs((Object)status);
    }

    @Test
    public void resumeWhileAssociatedBatch() {
        ContextualBatch contextualBatch = (ContextualBatch)Mockito.mock(ContextualBatch.class);
        ContextualSuspendedBatch contextualSuspendedBatch = (ContextualSuspendedBatch)Mockito.mock(ContextualSuspendedBatch.class);
        ((ContextualBatch)Mockito.doReturn((Object)contextualSuspendedBatch).when((Object)contextualBatch)).suspend();
        ThreadContextBatch.INSTANCE.accept(contextualBatch);
        SuspendedBatch suspended = ThreadContextBatch.INSTANCE.suspend();
        ContextualBatch currentBatch = (ContextualBatch)Mockito.mock(ContextualBatch.class);
        ThreadContextBatch.INSTANCE.accept(currentBatch);
        Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> ((SuspendedBatch)suspended).resume());
        ((ContextualBatch)Mockito.verify((Object)currentBatch)).attach((Throwable)Mockito.any());
    }

    @Test
    public void resumeWithContextWhileAssociatedBatch() {
        ContextualBatch contextualBatch = (ContextualBatch)Mockito.mock(ContextualBatch.class);
        ContextualSuspendedBatch contextualSuspendedBatch = (ContextualSuspendedBatch)Mockito.mock(ContextualSuspendedBatch.class);
        Batch.Status contextualStatus = (Batch.Status)Mockito.mock(Batch.Status.class);
        ((ContextualBatch)Mockito.doReturn((Object)contextualSuspendedBatch).when((Object)contextualBatch)).suspend();
        ((ContextualSuspendedBatch)Mockito.doReturn((Object)contextualBatch).when((Object)contextualSuspendedBatch)).resume();
        ((ContextualBatch)Mockito.doReturn((Object)contextualStatus).when((Object)contextualBatch)).getStatus();
        ((Batch.Status)Mockito.doReturn((Object)false).when((Object)contextualStatus)).isClosed();
        ThreadContextBatch.INSTANCE.accept(contextualBatch);
        SuspendedBatch suspended = ThreadContextBatch.INSTANCE.suspend();
        ((ContextualBatch)Mockito.verify((Object)contextualBatch)).suspend();
        ContextualBatch currentBatch = (ContextualBatch)Mockito.mock(ContextualBatch.class);
        ContextualSuspendedBatch currentSuspendedBatch = (ContextualSuspendedBatch)Mockito.mock(ContextualSuspendedBatch.class);
        Batch.Status currentStatus = (Batch.Status)Mockito.mock(Batch.Status.class);
        ThreadContextBatch.INSTANCE.accept(currentBatch);
        ((ContextualBatch)Mockito.doReturn((Object)currentSuspendedBatch).when((Object)currentBatch)).suspend();
        ((ContextualSuspendedBatch)Mockito.doReturn((Object)currentBatch).when((Object)currentSuspendedBatch)).resume();
        ((ContextualBatch)Mockito.doReturn((Object)currentStatus).when((Object)currentBatch)).getStatus();
        ((Batch.Status)Mockito.doReturn((Object)false).when((Object)currentStatus)).isClosed();
        try (Context context = suspended.resumeWithContext();){
            ((ContextualBatch)Mockito.verify((Object)currentBatch)).suspend();
            Mockito.verifyNoInteractions((Object[])new Object[]{currentSuspendedBatch});
            ((ContextualSuspendedBatch)Mockito.verify((Object)contextualSuspendedBatch)).resume();
            ((ContextualBatch)Mockito.verify((Object)contextualBatch)).getStatus();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{contextualBatch});
        }
        ((ContextualBatch)Mockito.verify((Object)contextualBatch, (VerificationMode)Mockito.times((int)2))).suspend();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{contextualSuspendedBatch});
        ((ContextualSuspendedBatch)Mockito.verify((Object)currentSuspendedBatch)).resume();
        ((ContextualBatch)Mockito.verify((Object)currentBatch)).getStatus();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{currentBatch});
    }

    @Test
    public void disassociated() {
        SuspendedBatch suspend = ThreadContextBatch.INSTANCE.suspend();
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
        Batch resumed = suspend.resume();
        Assertions.assertThat((Comparable)ThreadContextBatch.INSTANCE).isSameAs((Object)resumed);
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
        ThreadContextBatch.INSTANCE.discard();
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
        ThreadContextBatch.INSTANCE.close();
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
        Batch.Status status = ThreadContextBatch.INSTANCE.getStatus();
        Assertions.assertThat((Object)status).isNotNull();
        Assertions.assertThat((boolean)status.isActive()).isFalse();
        Assertions.assertThat((boolean)status.isDiscarding()).isFalse();
        Assertions.assertThat((boolean)status.isClosed()).isTrue();
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
    }

    @Test
    public void suspendResume() {
        ContextualBatch batch = (ContextualBatch)Mockito.mock(ContextualBatch.class);
        ContextualSuspendedBatch suspendedBatch = (ContextualSuspendedBatch)Mockito.mock(ContextualSuspendedBatch.class);
        Batch.Status status = (Batch.Status)Mockito.mock(Batch.Status.class);
        ((ContextualBatch)Mockito.doReturn((Object)status).when((Object)batch)).getStatus();
        ThreadContextBatch.INSTANCE.accept(batch);
        Mockito.verifyNoInteractions((Object[])new Object[]{batch});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isSameAs((Object)batch);
        ((ContextualBatch)Mockito.doReturn((Object)suspendedBatch).when((Object)batch)).suspend();
        ((ContextualSuspendedBatch)Mockito.doReturn((Object)batch).when((Object)suspendedBatch)).resume();
        SuspendedBatch suspended = ThreadContextBatch.INSTANCE.suspend();
        ((ContextualBatch)Mockito.verify((Object)batch, (VerificationMode)Mockito.only())).suspend();
        Mockito.verifyNoInteractions((Object[])new Object[]{suspendedBatch});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
        ((Batch.Status)Mockito.doReturn((Object)false).when((Object)status)).isClosed();
        Batch resumed = suspended.resume();
        ((ContextualSuspendedBatch)Mockito.verify((Object)suspendedBatch, (VerificationMode)Mockito.only())).resume();
        ((ContextualBatch)Mockito.verify((Object)batch)).getStatus();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch});
        Assertions.assertThat((Comparable)ThreadContextBatch.INSTANCE).isSameAs((Object)resumed);
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isSameAs((Object)batch);
    }

    @Test
    public void suspendResumeClosed() {
        ContextualBatch batch = (ContextualBatch)Mockito.mock(ContextualBatch.class);
        ContextualSuspendedBatch suspendedBatch = (ContextualSuspendedBatch)Mockito.mock(ContextualSuspendedBatch.class);
        Batch.Status status = (Batch.Status)Mockito.mock(Batch.Status.class);
        ((ContextualBatch)Mockito.doReturn((Object)status).when((Object)batch)).getStatus();
        ThreadContextBatch.INSTANCE.accept(batch);
        Mockito.verifyNoInteractions((Object[])new Object[]{batch});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isSameAs((Object)batch);
        ((ContextualBatch)Mockito.doReturn((Object)suspendedBatch).when((Object)batch)).suspend();
        ((ContextualSuspendedBatch)Mockito.doReturn((Object)batch).when((Object)suspendedBatch)).resume();
        SuspendedBatch suspended = ThreadContextBatch.INSTANCE.suspend();
        ((ContextualBatch)Mockito.verify((Object)batch, (VerificationMode)Mockito.only())).suspend();
        Mockito.verifyNoInteractions((Object[])new Object[]{suspendedBatch});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
        ((Batch.Status)Mockito.doReturn((Object)true).when((Object)status)).isClosed();
        Batch resumed = suspended.resume();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{suspendedBatch});
        ((ContextualBatch)Mockito.verify((Object)batch)).getStatus();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch});
        Assertions.assertThat((Comparable)ThreadContextBatch.INSTANCE).isSameAs((Object)resumed);
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
    }

    @Test
    public void close() {
        ContextualBatch batch = (ContextualBatch)Mockito.mock(ContextualBatch.class);
        Batch.Status openStatus = (Batch.Status)Mockito.mock(Batch.Status.class);
        Batch.Status closedStatus = (Batch.Status)Mockito.mock(Batch.Status.class);
        ThreadContextBatch.INSTANCE.accept(batch);
        Mockito.verifyNoInteractions((Object[])new Object[]{batch});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isSameAs((Object)batch);
        ((ContextualBatch)Mockito.doReturn((Object)openStatus, (Object[])new Object[]{closedStatus}).when((Object)batch)).getStatus();
        ((Batch.Status)Mockito.doReturn((Object)false).when((Object)openStatus)).isClosed();
        ((Batch.Status)Mockito.doReturn((Object)true).when((Object)closedStatus)).isClosed();
        ThreadContextBatch.INSTANCE.close();
        ((ContextualBatch)Mockito.verify((Object)batch)).close();
        ((ContextualBatch)Mockito.verify((Object)batch)).getStatus();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch});
        ((Batch.Status)Mockito.verify((Object)openStatus)).isClosed();
        Mockito.verifyNoInteractions((Object[])new Object[]{closedStatus});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isSameAs((Object)batch);
        ThreadContextBatch.INSTANCE.close();
        ((ContextualBatch)Mockito.verify((Object)batch, (VerificationMode)Mockito.times((int)2))).close();
        ((ContextualBatch)Mockito.verify((Object)batch, (VerificationMode)Mockito.times((int)2))).getStatus();
        ((Batch.Status)Mockito.verify((Object)closedStatus)).isClosed();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{openStatus});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
    }

    @Test
    public void discard() {
        ContextualBatch batch = (ContextualBatch)Mockito.mock(ContextualBatch.class);
        ThreadContextBatch.INSTANCE.accept(batch);
        Mockito.verifyNoInteractions((Object[])new Object[]{batch});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isSameAs((Object)batch);
        ThreadContextBatch.INSTANCE.discard();
        ((ContextualBatch)Mockito.verify((Object)batch, (VerificationMode)Mockito.only())).discard();
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isSameAs((Object)batch);
    }
}

