/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.marshalling;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.wildfly.clustering.cache.infinispan.marshalling.MarshalledValueTranscoder;
import org.wildfly.clustering.marshalling.MarshalledValue;
import org.wildfly.clustering.marshalling.MarshalledValueFactory;

@ExtendWith(value={MockitoExtension.class})
public class MarshalledValueTranscoderTestCase {
    @Mock
    private MarshalledValueFactory<Object> factory;
    @Mock
    private Marshaller marshaller;
    @Mock
    private MarshalledValue<Object, Object> value;

    @Test
    public void test() throws IOException, InterruptedException, ClassNotFoundException {
        MediaType type = new MediaType("application", "test");
        MarshalledValueTranscoder transcoder = new MarshalledValueTranscoder(type, this.factory, this.marshaller);
        Assertions.assertThat((boolean)transcoder.supports(type)).isTrue();
        List<MediaType> supportedMediaTypes = List.of(MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_OCTET_STREAM);
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)transcoder.getSupportedMediaTypes()).hasSize(3)).contains((Object[])new MediaType[]{type})).containsAll(supportedMediaTypes);
        for (MediaType mediaType : supportedMediaTypes) {
            Assertions.assertThat((boolean)transcoder.supports(mediaType)).isTrue();
            Assertions.assertThat((boolean)transcoder.supportsConversion(type, mediaType)).isTrue();
            Assertions.assertThat((boolean)transcoder.supportsConversion(mediaType, type)).isTrue();
            for (MediaType mediaType2 : supportedMediaTypes) {
                Assertions.assertThat((boolean)transcoder.supportsConversion(mediaType2, mediaType)).isFalse();
                Assertions.assertThat((boolean)transcoder.supportsConversion(mediaType, mediaType2)).isFalse();
            }
        }
        List<MediaType> unsupportedMediaTypes = List.of(MediaType.APPLICATION_JBOSS_MARSHALLING, MediaType.APPLICATION_PROTOSTREAM, MediaType.TEXT_PLAIN, MediaType.APPLICATION_JSON, MediaType.APPLICATION_SERIALIZED_OBJECT);
        for (MediaType unsupportedMediaType : unsupportedMediaTypes) {
            Assertions.assertThat((boolean)transcoder.supports(unsupportedMediaType)).isFalse();
            for (MediaType mediaType : supportedMediaTypes) {
                Assertions.assertThat((boolean)transcoder.supportsConversion(mediaType, unsupportedMediaType)).isFalse();
                Assertions.assertThat((boolean)transcoder.supportsConversion(unsupportedMediaType, mediaType)).isFalse();
            }
            for (MediaType mediaType : unsupportedMediaTypes) {
                Assertions.assertThat((boolean)transcoder.supportsConversion(mediaType, unsupportedMediaType)).isFalse();
                Assertions.assertThat((boolean)transcoder.supportsConversion(unsupportedMediaType, mediaType)).isFalse();
            }
        }
        Object object = new Object();
        Assertions.assertThat((Object)transcoder.transcode(object, type, type)).isSameAs(object);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.factory, this.marshaller});
        ((MarshalledValueFactory)Mockito.doReturn(this.value).when(this.factory)).createMarshalledValue(object);
        Assertions.assertThat((Object)transcoder.transcode(object, type, MediaType.APPLICATION_OBJECT)).isSameAs(this.value);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.marshaller});
        byte[] marshalled = new byte[]{};
        ((Marshaller)Mockito.doReturn((Object)marshalled).when((Object)this.marshaller)).objectToByteBuffer(this.value);
        Assertions.assertThat((Object)transcoder.transcode(object, type, MediaType.APPLICATION_OCTET_STREAM)).isSameAs((Object)marshalled);
        Object context = new Object();
        ((MarshalledValueFactory)Mockito.doReturn((Object)context).when(this.factory)).getMarshallingContext();
        ((MarshalledValue)Mockito.doReturn((Object)object).when(this.value)).get(context);
        Assertions.assertThat((Object)transcoder.transcode(this.value, MediaType.APPLICATION_OBJECT, type));
        ((Marshaller)Mockito.doReturn(this.value).when((Object)this.marshaller)).objectFromByteBuffer(marshalled);
        Assertions.assertThat((Object)transcoder.transcode((Object)marshalled, MediaType.APPLICATION_OCTET_STREAM, type));
    }
}

