/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.commons.api.BasicCache;
import org.wildfly.clustering.cache.infinispan.AbstractBasicCacheDecorator;

public class BlockingBasicCacheDecorator<K, V>
extends AbstractBasicCacheDecorator<K, V> {
    private final long timeoutNanos;

    protected BlockingBasicCacheDecorator(BasicCache<K, V> cache, Duration timeout) {
        super(cache);
        this.timeoutNanos = timeout.toNanos();
    }

    protected <T> T join(CompletableFuture<T> future) {
        try {
            return future.get(this.timeoutNanos, TimeUnit.NANOSECONDS);
        }
        catch (ExecutionException e) {
            throw new CompletionException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CancellationException(e.getLocalizedMessage());
        }
        catch (TimeoutException e) {
            future.cancel(false);
            throw new CancellationException(e.getLocalizedMessage());
        }
    }

    public void clear() {
        this.join(this.clearAsync());
    }

    public boolean containsKey(Object key) {
        return this.join(this.containsKeyAsync(key));
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.join(this.computeAsync(key, remappingFunction));
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.join(this.computeAsync(key, remappingFunction, lifespan, lifespanUnit));
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.join(this.computeAsync(key, remappingFunction, lifespan, lifespanUnit));
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.join(this.computeIfAbsentAsync(key, mappingFunction));
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.join(this.computeIfAbsentAsync(key, mappingFunction, lifespan, lifespanUnit));
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.join(this.computeIfAbsentAsync(key, mappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.join(this.computeIfPresentAsync(key, remappingFunction));
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.join(this.computeIfPresentAsync(key, remappingFunction, lifespan, lifespanUnit));
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.join(this.computeIfPresentAsync(key, remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    public V get(Object key) {
        return this.join(this.getAsync(key));
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.join(this.mergeAsync(key, value, remappingFunction));
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.join(this.mergeAsync(key, value, remappingFunction, lifespan, lifespanUnit));
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.join(this.mergeAsync(key, value, remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    public V put(K key, V value) {
        return this.join(this.putAsync(key, value));
    }

    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        return this.join(this.putAsync(key, value, lifespan, lifespanUnit));
    }

    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.join(this.putAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.join(this.putAllAsync(map));
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit) {
        this.join(this.putAllAsync(map, lifespan, lifespanUnit));
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.join(this.putAllAsync(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    public V putIfAbsent(K key, V value) {
        return this.join(this.putIfAbsentAsync(key, value));
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        return this.join(this.putIfAbsentAsync(key, value, lifespan, unit));
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.join(this.putIfAbsentAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    public V remove(Object key) {
        return this.join(this.removeAsync(key));
    }

    public boolean remove(Object key, Object value) {
        return this.join(this.removeAsync(key, value));
    }

    public V replace(K key, V value) {
        return this.join(this.replaceAsync(key, value));
    }

    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        return this.join(this.replaceAsync(key, value, lifespan, lifespanUnit));
    }

    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.join(this.replaceAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.join(this.replaceAsync(key, oldValue, newValue));
    }

    public boolean replace(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit) {
        return this.join(this.replaceAsync(key, oldValue, newValue, lifespan, lifespanUnit));
    }

    public boolean replace(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.join(this.replaceAsync(key, oldValue, newValue, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    public int size() {
        return this.join(this.sizeAsync()).intValue();
    }
}

