/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.batch;

import java.util.concurrent.atomic.AtomicBoolean;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.infinispan.batch.AbstractContextualBatch;
import org.wildfly.clustering.cache.infinispan.batch.ContextualBatch;
import org.wildfly.clustering.cache.infinispan.batch.ContextualSuspendedBatch;
import org.wildfly.clustering.function.Consumer;

public class SimpleContextualBatch
extends AbstractContextualBatch
implements ContextualSuspendedBatch {
    private final long id;
    private final Batch.Status status;

    SimpleContextualBatch(String name, long id) {
        this(name, id, new AtomicBoolean(true));
    }

    private SimpleContextualBatch(String name, long id, final AtomicBoolean active) {
        super(name, (Consumer<Batch.Status>)((Consumer)status -> {
            active.set(false);
            LOGGER.log(System.Logger.Level.TRACE, "Closed batch {0}", id);
        }));
        this.id = id;
        this.status = new Batch.Status(){
            final /* synthetic */ SimpleContextualBatch this$0;
            {
                this.this$0 = this$0;
            }

            public boolean isActive() {
                return active.get();
            }

            public boolean isDiscarding() {
                return false;
            }

            public boolean isClosed() {
                return !active.get();
            }
        };
        LOGGER.log(System.Logger.Level.TRACE, "Created batch {0}", id);
    }

    public Batch.Status getStatus() {
        return this.status;
    }

    @Override
    public ContextualBatch resume() {
        return this;
    }

    @Override
    public ContextualSuspendedBatch suspend() {
        return this;
    }

    public void discard() {
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SimpleContextualBatch)) {
            return false;
        }
        SimpleContextualBatch batch = (SimpleContextualBatch)object;
        return this.id == batch.id;
    }

    public String toString() {
        return String.valueOf(this.id);
    }
}

