/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.marshalling;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.OptionalInt;
import java.util.function.Supplier;
import org.infinispan.commons.dataconversion.MediaType;
import org.wildfly.clustering.cache.infinispan.marshalling.AbstractMarshaller;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;

public class UserMarshaller
extends AbstractMarshaller {
    private final MediaType type;
    private final ByteBufferMarshaller marshaller;

    public UserMarshaller(Supplier<MediaType> type, ByteBufferMarshaller marshaller) {
        this(type.get(), marshaller);
    }

    public UserMarshaller(MediaType type, ByteBufferMarshaller marshaller) {
        this.type = type;
        this.marshaller = marshaller;
    }

    @Override
    public int sizeEstimate(Object object) {
        OptionalInt size = this.marshaller.size(object);
        return size.isPresent() ? size.getAsInt() : super.sizeEstimate(object);
    }

    public boolean isMarshallable(Object object) {
        return this.marshaller.test(object);
    }

    public Object readObject(InputStream input) throws IOException {
        return this.marshaller.readFrom(input);
    }

    public void writeObject(Object object, OutputStream output) throws IOException {
        this.marshaller.writeTo(output, object);
    }

    public MediaType mediaType() {
        return this.type;
    }
}

