/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.container;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.infinispan.commons.util.EntrySizeCalculator;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.BoundedSegmentedDataContainer;
import org.infinispan.container.impl.DefaultDataContainer;
import org.infinispan.container.impl.DefaultSegmentedDataContainer;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.L1SegmentedDataContainer;
import org.infinispan.container.impl.PeekableTouchableContainerMap;
import org.infinispan.container.impl.PeekableTouchableMap;
import org.infinispan.container.offheap.BoundedOffHeapDataContainer;
import org.infinispan.container.offheap.OffHeapConcurrentMap;
import org.infinispan.container.offheap.OffHeapDataContainer;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.offheap.SegmentedBoundedOffHeapDataContainer;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.wildfly.clustering.cache.infinispan.embedded.container.DataContainerConfiguration;

@DefaultFactoryFor(classes={InternalDataContainer.class})
@SurvivesRestarts
public class DataContainerFactory<K, V>
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    public Object construct(String componentName) {
        MemoryConfiguration memory = this.configuration.memory();
        EvictionStrategy strategy = memory.whenFull();
        if (strategy.isExceptionBased() || !strategy.isEnabled()) {
            return this.createUnboundedContainer();
        }
        DataContainer<?, ?> container = this.createBoundedDataContainer();
        memory.attributes().attribute(MemoryConfiguration.MAX_COUNT).addListener((newSize, oldSize) -> container.resize(((Long)newSize.get()).longValue()));
        return container;
    }

    private DataContainer<?, ?> createUnboundedContainer() {
        ClusteringConfiguration clustering = this.configuration.clustering();
        boolean segmented = clustering.cacheMode().needsStateTransfer();
        int level = this.configuration.locking().concurrencyLevel();
        boolean offHeap = this.configuration.memory().isOffHeap();
        if (segmented) {
            Supplier<PeekableTouchableMap> mapSupplier = offHeap ? this::createAndStartOffHeapConcurrentMap : PeekableTouchableContainerMap::new;
            int segments = clustering.hash().numSegments();
            return clustering.l1().enabled() ? new L1SegmentedDataContainer(mapSupplier, segments) : new DefaultSegmentedDataContainer(mapSupplier, segments);
        }
        return offHeap ? new OffHeapDataContainer() : DefaultDataContainer.unBoundedDataContainer((int)level);
    }

    private DataContainer<?, ?> createBoundedDataContainer() {
        Predicate evictable;
        ClusteringConfiguration clustering = this.configuration.clustering();
        boolean segmented = clustering.cacheMode().needsStateTransfer();
        int level = this.configuration.locking().concurrencyLevel();
        MemoryConfiguration memory = this.configuration.memory();
        boolean offHeap = memory.isOffHeap();
        long maxEntries = memory.maxCount();
        long maxBytes = memory.maxSizeBytes();
        EvictionType type = memory.evictionType();
        DataContainerConfiguration config = (DataContainerConfiguration)this.configuration.module(DataContainerConfiguration.class);
        Predicate predicate = evictable = config != null ? config.evictable() : (Predicate)DataContainerConfiguration.EVICTABLE_PREDICATE.getDefaultValue();
        if (segmented) {
            int segments = clustering.hash().numSegments();
            if (offHeap) {
                return new SegmentedBoundedOffHeapDataContainer(segments, maxEntries, type);
            }
            return maxEntries > 0L ? new BoundedSegmentedDataContainer(segments, maxEntries, new EvictableEntrySizeCalculator(evictable)) : new BoundedSegmentedDataContainer(segments, maxBytes, type);
        }
        if (offHeap) {
            return new BoundedOffHeapDataContainer(maxEntries, type);
        }
        return maxEntries > 0L ? new EvictableDataContainer(maxEntries, new EvictableEntrySizeCalculator(evictable)) : DefaultDataContainer.boundedDataContainer((int)level, (long)maxBytes, (EvictionType)type);
    }

    private OffHeapConcurrentMap createAndStartOffHeapConcurrentMap() {
        OffHeapEntryFactory entryFactory = (OffHeapEntryFactory)this.basicComponentRegistry.getComponent(OffHeapEntryFactory.class).wired();
        OffHeapMemoryAllocator memoryAllocator = (OffHeapMemoryAllocator)this.basicComponentRegistry.getComponent(OffHeapMemoryAllocator.class).wired();
        return new OffHeapConcurrentMap(memoryAllocator, entryFactory, null);
    }

    private static class EvictableEntrySizeCalculator<K, V>
    implements EntrySizeCalculator<K, InternalCacheEntry<K, V>> {
        private final Predicate<K> evictable;

        EvictableEntrySizeCalculator(Predicate<K> evictable) {
            this.evictable = evictable;
        }

        public long calculateSize(K key, InternalCacheEntry<K, V> value) {
            return this.evictable.test(key) ? 1L : 0L;
        }
    }

    public static class EvictableDataContainer<K, V>
    extends DefaultDataContainer<K, V> {
        EvictableDataContainer(long size, EntrySizeCalculator<? super K, ? super InternalCacheEntry<K, V>> calculator) {
            super(size, calculator);
        }
    }
}

