/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.marshall;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamAwareMarshaller;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.SerializationContextInitializer;
import org.wildfly.clustering.cache.infinispan.marshalling.AbstractMarshaller;

@Scope(value=Scopes.GLOBAL)
public class PersistenceMarshaller
extends AbstractMarshaller
implements org.infinispan.marshall.persistence.PersistenceMarshaller {
    @Inject
    GlobalComponentRegistry registry;
    @Inject
    SerializationContextRegistry contextRegistry;
    private StreamAwareMarshaller streamAwareUserMarshaller;
    private Marshaller userMarshaller;

    @Start
    public void start() {
        this.userMarshaller = this.registry.getGlobalConfiguration().serialization().marshaller();
        this.streamAwareUserMarshaller = (StreamAwareMarshaller)this.userMarshaller;
    }

    public boolean isMarshallable(Object object) {
        return this.streamAwareUserMarshaller.isMarshallable(object);
    }

    public MediaType mediaType() {
        return this.userMarshaller.mediaType();
    }

    public void writeObject(Object object, OutputStream output) throws IOException {
        this.streamAwareUserMarshaller.writeObject(object, output);
    }

    public Object readObject(InputStream input) throws ClassNotFoundException, IOException {
        return this.streamAwareUserMarshaller.readObject(input);
    }

    public void register(SerializationContextInitializer initializer) {
        this.contextRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.PERSISTENCE, initializer);
    }

    public Marshaller getUserMarshaller() {
        return this.userMarshaller;
    }
}

