/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.metadata;

import java.io.IOException;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class EmbeddedMetadataMarshaller<MD extends EmbeddedMetadata>
implements ProtoStreamMarshaller<EmbeddedMetadata> {
    private static final int VERSION_INDEX = 1;
    private static final int TOPOLOGY_INDEX = 2;
    private static final int LIFESPAN_INDEX = 3;
    private static final int MAX_IDLE_INDEX = 4;
    private Class<MD> targetClass;

    EmbeddedMetadataMarshaller(Class<MD> targetClass) {
        this.targetClass = targetClass;
    }

    public EmbeddedMetadata readFrom(ProtoStreamReader reader) throws IOException {
        EmbeddedMetadata.Builder builder = new EmbeddedMetadata.Builder();
        Long version = null;
        Integer topologyId = null;
        block6: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    version = reader.readSInt64();
                    continue block6;
                }
                case 2: {
                    topologyId = reader.readSInt32();
                    continue block6;
                }
                case 3: {
                    builder.lifespan(reader.readUInt64());
                    continue block6;
                }
                case 4: {
                    builder.maxIdle(reader.readUInt64());
                    continue block6;
                }
            }
            reader.skipField(tag);
        }
        if (version != null) {
            builder.version((EntryVersion)(topologyId != null ? new SimpleClusteredVersion(topologyId.intValue(), version.longValue()) : new NumericVersion(version.longValue())));
        }
        return (EmbeddedMetadata)builder.build();
    }

    public void writeTo(ProtoStreamWriter writer, EmbeddedMetadata metadata) throws IOException {
        if (metadata.getClusteredVersion() != null) {
            writer.writeSInt64(1, metadata.getClusteredVersion().getVersion());
            writer.writeSInt32(2, metadata.getClusteredVersion().getTopologyId());
        } else if (metadata.getNumericVersion() != null) {
            writer.writeSInt64(1, metadata.getNumericVersion().getVersion());
        }
        if (metadata.lifespan() != -1L) {
            writer.writeUInt64(3, metadata.lifespan());
        }
        if (metadata.maxIdle() != -1L) {
            writer.writeUInt64(4, metadata.maxIdle());
        }
    }

    public Class<? extends EmbeddedMetadata> getJavaClass() {
        return this.targetClass;
    }
}

