/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.persistence;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.wildfly.clustering.marshalling.Formatter;
import org.wildfly.common.Assert;

public class IndexedKeyFormatMapper
implements TwoWayKey2StringMapper {
    private static final int HEX_RADIX = 16;
    private final Map<Class<?>, Integer> indexes = new IdentityHashMap();
    private final List<Formatter<Object>> keyFormats;
    private final int padding;

    public static TwoWayKey2StringMapper load(ClassLoader loader) {
        LinkedList<Formatter> keyFormats = new LinkedList<Formatter>();
        for (Formatter keyFormat : ServiceLoader.load(Formatter.class, loader)) {
            keyFormats.add(keyFormat);
        }
        ArrayList<Object> result = new ArrayList<Object>(keyFormats.size() + 6);
        result.add(Formatter.IDENTITY);
        result.add(Formatter.IDENTITY.wrap(Byte.class, Byte::valueOf));
        result.add(Formatter.IDENTITY.wrap(Short.class, Short::valueOf));
        result.add(Formatter.IDENTITY.wrap(Integer.class, Integer::valueOf));
        result.add(Formatter.IDENTITY.wrap(Long.class, Long::valueOf));
        result.add(Formatter.IDENTITY.wrap(UUID.class, UUID::fromString));
        result.addAll(keyFormats);
        return new IndexedKeyFormatMapper(result);
    }

    public IndexedKeyFormatMapper(List<? extends Formatter<?>> formatters) {
        this.keyFormats = formatters;
        for (int i = 0; i < this.keyFormats.size(); ++i) {
            this.indexes.put(this.keyFormats.get(i).getTargetClass(), i);
        }
        this.padding = (int)(Math.log((double)this.keyFormats.size() - 1.0) / Math.log(16.0)) + 1;
    }

    public boolean isSupportedType(Class<?> keyType) {
        return this.indexes.containsKey(keyType);
    }

    public String getStringMapping(Object key) {
        Assert.checkNotNullParam((String)"key", (Object)key);
        Integer index = this.indexes.get(key.getClass());
        if (index == null) {
            throw new IllegalArgumentException(key.getClass().getName());
        }
        Formatter<Object> keyFormat = this.keyFormats.get(index);
        return String.format("%0" + this.padding + "X%s", index, keyFormat.format(key));
    }

    public Object getKeyMapping(String value) {
        int index = Integer.parseUnsignedInt(value.substring(0, this.padding), 16);
        Formatter<Object> keyFormat = this.keyFormats.get(index);
        return keyFormat.parse(value.substring(this.padding));
    }
}

