/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.persistence;

import java.util.function.BiConsumer;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.junit.jupiter.api.Assertions;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.TesterFactory;

public interface FormatterTesterFactory
extends TesterFactory {
    default public <T> Tester<T> createTester(final BiConsumer<T, T> assertion) {
        final TwoWayKey2StringMapper mapper = this.getMapper();
        return new Tester<T>(){

            public void accept(T key) {
                Class<?> keyClass = key.getClass();
                Assertions.assertTrue((boolean)mapper.isSupportedType(keyClass), key::toString);
                String string = mapper.getStringMapping(key);
                System.out.println(String.format("%s\t%s\t%s\t%d", mapper.getClass().getSimpleName(), keyClass.getCanonicalName(), key, string.length()));
                Object remappedKey = mapper.getKeyMapping(string);
                assertion.accept(key, remappedKey);
            }

            public void reject(T key) {
                Assertions.assertFalse((boolean)mapper.isSupportedType(key.getClass()), key::toString);
            }

            public <E extends Throwable> void reject(T key, Class<E> expected) {
                Assertions.assertTrue((boolean)mapper.isSupportedType(key.getClass()), key::toString);
                Assertions.assertThrows(expected, () -> mapper.getStringMapping(key), key::toString);
            }
        };
    }

    public TwoWayKey2StringMapper getMapper();
}

