/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.persistence;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.wildfly.clustering.marshalling.Formatter;
import org.wildfly.common.Assert;

public class FormatterKeyMapper
implements TwoWayKey2StringMapper {
    private static final int HEX_RADIX = 16;
    private final Map<Class<?>, Integer> indexes = new IdentityHashMap();
    private final List<Formatter<Object>> formatters;
    private final int padding;

    public static TwoWayKey2StringMapper load(ClassLoader loader) {
        LinkedList<Formatter> formatters = new LinkedList<Formatter>();
        for (Formatter formatter : ServiceLoader.load(Formatter.class, loader)) {
            formatters.add(formatter);
        }
        ArrayList<Object> result = new ArrayList<Object>(formatters.size() + 6);
        result.add(Formatter.IDENTITY);
        result.add(Formatter.IDENTITY.wrap(Byte.class, Byte::valueOf));
        result.add(Formatter.IDENTITY.wrap(Short.class, Short::valueOf));
        result.add(Formatter.IDENTITY.wrap(Integer.class, Integer::valueOf));
        result.add(Formatter.IDENTITY.wrap(Long.class, Long::valueOf));
        result.add(Formatter.IDENTITY.wrap(UUID.class, UUID::fromString));
        result.addAll(formatters);
        return new FormatterKeyMapper(result);
    }

    public FormatterKeyMapper(List<? extends Formatter<?>> formatters) {
        this.formatters = formatters;
        for (int i = 0; i < this.formatters.size(); ++i) {
            this.indexes.put(this.formatters.get(i).getType(), i);
        }
        this.padding = (int)(Math.log((double)this.formatters.size() - 1.0) / Math.log(16.0)) + 1;
    }

    public boolean isSupportedType(Class<?> keyType) {
        return this.indexes.containsKey(keyType);
    }

    public String getStringMapping(Object key) {
        Assert.checkNotNullParam((String)"key", (Object)key);
        Integer index = this.indexes.get(key.getClass());
        if (index == null) {
            throw new IllegalArgumentException(key.getClass().getName());
        }
        Formatter<Object> formatter = this.formatters.get(index);
        return String.format("%0" + this.padding + "X%s", index, formatter.format(key));
    }

    public Object getKeyMapping(String value) {
        int index = Integer.parseUnsignedInt(value.substring(0, this.padding), 16);
        Formatter<Object> formatter = this.formatters.get(index);
        return formatter.parse(value.substring(this.padding));
    }
}

