/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.persistence;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.wildfly.clustering.marshalling.Formatter;
import org.wildfly.common.Assert;

public class FormatterKeyMapper
implements TwoWayKey2StringMapper {
    private static final int HEX_RADIX = 16;
    private static final List<Formatter<?>> DEFAULT_FORMATTERS = List.of(Formatter.IDENTITY, Formatter.IDENTITY.wrap(Byte.class, Byte::valueOf), Formatter.IDENTITY.wrap(Short.class, Short::valueOf), Formatter.IDENTITY.wrap(Integer.class, Integer::valueOf), Formatter.IDENTITY.wrap(Long.class, Long::valueOf), Formatter.IDENTITY.wrap(UUID.class, UUID::fromString));
    private final Map<Class<?>, Integer> indexes = new IdentityHashMap();
    private final List<Formatter<?>> formatters;
    private final int padding;

    public FormatterKeyMapper() {
        final LinkedList formatters = new LinkedList();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Void run() {
                ServiceLoader.load(Formatter.class, FormatterKeyMapper.this.getClass().getClassLoader()).forEach(formatters::add);
                return null;
            }
        });
        this.formatters = new ArrayList(DEFAULT_FORMATTERS.size() + formatters.size());
        this.formatters.addAll(DEFAULT_FORMATTERS);
        this.formatters.addAll(formatters);
        this.padding = this.padding();
    }

    public FormatterKeyMapper(List<? extends Formatter<?>> formatters) {
        this.formatters = List.copyOf(formatters);
        this.padding = this.padding();
    }

    private int padding() {
        for (int i = 0; i < this.formatters.size(); ++i) {
            this.indexes.put(this.formatters.get(i).getType(), i);
        }
        return (int)(Math.log((double)this.formatters.size() - 1.0) / Math.log(16.0)) + 1;
    }

    public boolean isSupportedType(Class<?> keyType) {
        return this.indexes.containsKey(keyType);
    }

    public String getStringMapping(Object key) {
        Assert.checkNotNullParam((String)"key", (Object)key);
        Integer index = this.indexes.get(key.getClass());
        if (index == null) {
            throw new IllegalArgumentException(key.getClass().getName());
        }
        Formatter<?> formatter = this.formatters.get(index);
        return String.format("%0" + this.padding + "X%s", index, formatter.format(key));
    }

    public Object getKeyMapping(String value) {
        int index = Integer.parseUnsignedInt(value.substring(0, this.padding), 16);
        Formatter<?> formatter = this.formatters.get(index);
        return formatter.parse(value.substring(this.padding));
    }
}

