/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.persistence;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.cache.infinispan.embedded.persistence.FormatterKeyMapper;
import org.wildfly.clustering.marshalling.Formatter;

public class FormatterKeyMapperTestCase {
    @Test
    public void testSinglePadding() {
        FormatterKeyMapper mapper = new FormatterKeyMapper(FormatterKeyMapperTestCase.createPersistenceList(16));
        Assertions.assertTrue((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE00)).getClass()));
        Assertions.assertTrue((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE15)).getClass()));
        Assertions.assertFalse((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE16)).getClass()));
        Assertions.assertFalse((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE17)).getClass()));
        String result = mapper.getStringMapping((Object)Type.TYPE00);
        Assertions.assertSame((Object)((Object)Type.TYPE00), (Object)mapper.getKeyMapping(result));
        Assertions.assertEquals((Object)"0TYPE00", (Object)result);
        result = mapper.getStringMapping((Object)Type.TYPE15);
        Assertions.assertSame((Object)((Object)Type.TYPE15), (Object)mapper.getKeyMapping(result));
        Assertions.assertEquals((Object)"FTYPE15", (Object)result);
    }

    @Test
    public void testDoublePadding() {
        FormatterKeyMapper mapper = new FormatterKeyMapper(FormatterKeyMapperTestCase.createPersistenceList(17));
        Assertions.assertTrue((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE00)).getClass()));
        Assertions.assertTrue((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE15)).getClass()));
        Assertions.assertTrue((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE16)).getClass()));
        Assertions.assertFalse((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE17)).getClass()));
        String result = mapper.getStringMapping((Object)Type.TYPE00);
        Assertions.assertSame((Object)((Object)Type.TYPE00), (Object)mapper.getKeyMapping(result));
        Assertions.assertEquals((Object)"00TYPE00", (Object)result);
        result = mapper.getStringMapping((Object)Type.TYPE15);
        Assertions.assertSame((Object)((Object)Type.TYPE15), (Object)mapper.getKeyMapping(result));
        Assertions.assertEquals((Object)"0FTYPE15", (Object)result);
        result = mapper.getStringMapping((Object)Type.TYPE16);
        Assertions.assertSame((Object)((Object)Type.TYPE16), (Object)mapper.getKeyMapping(result));
        Assertions.assertEquals((Object)"10TYPE16", (Object)result);
    }

    private static List<? extends Formatter<?>> createPersistenceList(int size) {
        return IntStream.range(0, size).mapToObj(index -> Formatter.IDENTITY.wrap(((Object)((Object)Type.values()[index])).getClass(), Enum::name, value -> Type.valueOf(value))).collect(Collectors.toList());
    }

    static enum Type {
        TYPE00{}
        ,
        TYPE01{}
        ,
        TYPE02{}
        ,
        TYPE03{}
        ,
        TYPE04{}
        ,
        TYPE05{}
        ,
        TYPE06{}
        ,
        TYPE07{}
        ,
        TYPE08{}
        ,
        TYPE09{}
        ,
        TYPE10{}
        ,
        TYPE11{}
        ,
        TYPE12{}
        ,
        TYPE13{}
        ,
        TYPE14{}
        ,
        TYPE15{}
        ,
        TYPE16{}
        ,
        TYPE17{};

    }
}

