/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.marshall;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.util.logging.Log;
import org.wildfly.clustering.cache.infinispan.embedded.marshall.EncoderRegistry;

@Scope(value=Scopes.GLOBAL)
public class DefaultEncoderRegistry
implements EncoderRegistry {
    private final Map<Short, Encoder> encoders = new ConcurrentHashMap<Short, Encoder>();
    private final Map<Byte, Wrapper> wrappers = new ConcurrentHashMap<Byte, Wrapper>();
    private final List<Transcoder> transcoders = Collections.synchronizedList(new ArrayList());
    private final Map<MediaType, Map<MediaType, Transcoder>> transcoderCache = new ConcurrentHashMap<MediaType, Map<MediaType, Transcoder>>();

    public void registerTranscoder(Transcoder transcoder) {
        this.transcoders.add(transcoder);
    }

    public Transcoder getTranscoder(MediaType fromType, MediaType toType) {
        Transcoder transcoder = this.findTranscoder(fromType, toType);
        if (transcoder == null) {
            throw Log.CONTAINER.cannotFindTranscoder(fromType, toType);
        }
        return transcoder;
    }

    public <T extends Transcoder> T getTranscoder(Class<T> targetClass) {
        return (T)((Transcoder)targetClass.cast(this.transcoders.stream().filter(p -> p.getClass().equals(targetClass)).findAny().orElse(null)));
    }

    public boolean isConversionSupported(MediaType fromType, MediaType toType) {
        return fromType.match(toType) || this.findTranscoder(fromType, toType) != null;
    }

    public Object convert(Object object, MediaType fromType, MediaType toType) {
        if (object == null) {
            return null;
        }
        return this.getTranscoder(fromType, toType).transcode(object, fromType, toType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterTranscoder(MediaType type) {
        List<Transcoder> list = this.transcoders;
        synchronized (list) {
            Iterator<Transcoder> iterator = this.transcoders.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getSupportedMediaTypes().contains(type)) continue;
                iterator.remove();
            }
        }
        this.transcoderCache.remove(type);
        for (Map map : this.transcoderCache.values()) {
            map.remove(type);
        }
    }

    private Transcoder findTranscoder(MediaType fromType, MediaType toType) {
        return this.transcoderCache.computeIfAbsent(fromType, mt -> new ConcurrentHashMap(4)).computeIfAbsent(toType, mt -> this.transcoders.stream().filter(t -> t.supportsConversion(fromType, toType)).findFirst().orElse(null));
    }

    @Deprecated
    public Encoder getEncoder(Class<? extends Encoder> encoderClass, short encoderId) {
        if (encoderId != 0) {
            Encoder encoder = this.encoders.get(encoderId);
            if (encoder == null) {
                throw Log.CONTAINER.encoderIdNotFound(encoderId);
            }
            return encoder;
        }
        Encoder encoder = this.encoders.values().stream().filter(e -> e.getClass().equals(encoderClass)).findFirst().orElse(null);
        if (encoder == null) {
            throw Log.CONTAINER.encoderClassNotFound(encoderClass);
        }
        return encoder;
    }

    @Deprecated
    public boolean isRegistered(Class<? extends Encoder> encoderClass) {
        return this.encoders.values().stream().anyMatch(e -> e.getClass().equals(encoderClass));
    }

    @Deprecated
    public Wrapper getWrapper(Class<? extends Wrapper> wrapperClass, byte wrapperId) {
        if (wrapperClass == null && wrapperId == 0) {
            return null;
        }
        if (wrapperId != 0) {
            Wrapper wrapper = this.wrappers.get(wrapperId);
            if (wrapper == null) {
                throw Log.CONTAINER.wrapperIdNotFound(wrapperId);
            }
            return wrapper;
        }
        Wrapper wrapper = this.wrappers.values().stream().filter(e -> e.getClass().equals(wrapperClass)).findAny().orElse(null);
        if (wrapper == null) {
            throw Log.CONTAINER.wrapperClassNotFound(wrapperClass);
        }
        return wrapper;
    }

    @Deprecated
    public void registerEncoder(Encoder encoder) {
        short id = encoder.id();
        if (this.encoders.putIfAbsent(id, encoder) != null) {
            throw Log.CONTAINER.duplicateIdEncoder(id);
        }
    }

    @Deprecated
    public void registerWrapper(Wrapper wrapper) {
        byte id = wrapper.id();
        if (this.wrappers.putIfAbsent(id, wrapper) != null) {
            throw Log.CONTAINER.duplicateIdWrapper(id);
        }
    }
}

