/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.affinity;

import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.BlockingQueue;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.cache.infinispan.embedded.affinity.ConsistentHashKeyRegistry;

public class ConsistentHashKeyRegistryTestCase {
    @Test
    public void test() {
        ConsistentHash hash = (ConsistentHash)Mockito.mock(ConsistentHash.class);
        Predicate filter = (Predicate)Mockito.mock(Predicate.class);
        Supplier queueFactory = (Supplier)Mockito.mock(Supplier.class);
        Address local = (Address)Mockito.mock(Address.class);
        Address filtered = (Address)Mockito.mock(Address.class);
        Address standby = (Address)Mockito.mock(Address.class);
        BlockingQueue queue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
        Mockito.when((Object)hash.getMembers()).thenReturn(Arrays.asList(local, filtered, standby));
        Mockito.when((Object)filter.test(local)).thenReturn((Object)true);
        Mockito.when((Object)filter.test(filtered)).thenReturn((Object)false);
        Mockito.when((Object)filter.test(standby)).thenReturn((Object)true);
        Mockito.when((Object)hash.getPrimarySegmentsForOwner(local)).thenReturn(Collections.singleton(1));
        Mockito.when((Object)hash.getPrimarySegmentsForOwner(standby)).thenReturn(Collections.emptySet());
        Mockito.when((Object)((BlockingQueue)queueFactory.get())).thenReturn((Object)queue);
        ConsistentHashKeyRegistry registry = new ConsistentHashKeyRegistry(hash, filter, queueFactory);
        Assertions.assertTrue((boolean)registry.getAddresses().contains(local));
        Assertions.assertFalse((boolean)registry.getAddresses().contains(filtered));
        Assertions.assertFalse((boolean)registry.getAddresses().contains(standby));
        Assertions.assertEquals(Collections.singleton(local), (Object)registry.getAddresses());
        Assertions.assertSame((Object)queue, (Object)registry.getKeys(local));
        Assertions.assertNull((Object)registry.getKeys(standby));
        Assertions.assertNull((Object)registry.getKeys(filtered));
    }
}

