/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.distribution;

import org.assertj.core.api.Assertions;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.remoting.transport.Address;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.ConsistentHashKeyDistribution;
import org.wildfly.common.function.Functions;

public class ConsistentHashKeyDistributionTestCase {
    @Test
    public void test() {
        KeyPartitioner partitioner = (KeyPartitioner)Mockito.mock(KeyPartitioner.class);
        DistributionManager dist = (DistributionManager)Mockito.mock(DistributionManager.class);
        ConsistentHash hash = (ConsistentHash)Mockito.mock(ConsistentHash.class);
        ConsistentHashKeyDistribution distribution = new ConsistentHashKeyDistribution(dist, Functions.constantSupplier((Object)hash));
        Address address = (Address)Mockito.mock(Address.class);
        Object key = new Object();
        int segment = 4;
        LocalizedCacheTopology topology = LocalizedCacheTopology.makeSegmentedSingletonTopology((KeyPartitioner)partitioner, (int)8, (Address)address);
        ((DistributionManager)Mockito.doReturn((Object)topology).when((Object)dist)).getCacheTopology();
        ((KeyPartitioner)Mockito.doReturn((Object)segment).when((Object)partitioner)).getSegment(key);
        ((ConsistentHash)Mockito.doReturn((Object)address).when((Object)hash)).locatePrimaryOwnerForSegment(segment);
        Mockito.when((Object)hash.locatePrimaryOwnerForSegment(segment)).thenReturn((Object)address);
        Address result = distribution.getPrimaryOwner(key);
        Assertions.assertThat((Comparable)result).isSameAs((Object)address);
    }
}

