/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.affinity;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.BlockingQueue;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.cache.infinispan.embedded.affinity.ConsistentHashKeyRegistry;

public class ConsistentHashKeyRegistryTestCase {
    @Test
    public void test() {
        ConsistentHash hash = (ConsistentHash)Mockito.mock(ConsistentHash.class);
        Predicate filter = (Predicate)Mockito.mock(Predicate.class);
        Supplier queueFactory = (Supplier)Mockito.mock(Supplier.class);
        Address local = (Address)Mockito.mock(Address.class);
        Address filtered = (Address)Mockito.mock(Address.class);
        Address standby = (Address)Mockito.mock(Address.class);
        BlockingQueue queue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
        Mockito.when((Object)hash.getMembers()).thenReturn(Arrays.asList(local, filtered, standby));
        Mockito.when((Object)filter.test(local)).thenReturn((Object)true);
        Mockito.when((Object)filter.test(filtered)).thenReturn((Object)false);
        Mockito.when((Object)filter.test(standby)).thenReturn((Object)true);
        Mockito.when((Object)hash.getPrimarySegmentsForOwner(local)).thenReturn(Collections.singleton(1));
        Mockito.when((Object)hash.getPrimarySegmentsForOwner(standby)).thenReturn(Collections.emptySet());
        Mockito.when((Object)((BlockingQueue)queueFactory.get())).thenReturn((Object)queue);
        ConsistentHashKeyRegistry registry = new ConsistentHashKeyRegistry(hash, filter, queueFactory);
        Assertions.assertThat((Collection)registry.getAddresses()).contains((Object[])new Address[]{local});
        Assertions.assertThat((Collection)registry.getAddresses()).doesNotContain((Object[])new Address[]{filtered});
        Assertions.assertThat((Collection)registry.getAddresses()).doesNotContain((Object[])new Address[]{standby});
        Assertions.assertThat((Collection)registry.getAddresses()).containsExactly((Object[])new Address[]{local});
        Assertions.assertThat((Collection)registry.getKeys(local)).isSameAs((Object)queue);
        Assertions.assertThat((Collection)registry.getKeys(standby)).isNull();
        Assertions.assertThat((Collection)registry.getKeys(filtered)).isNull();
    }
}

