/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.concurrent.BlockingManager;
import org.wildfly.clustering.cache.infinispan.BasicCacheContainerConfiguration;

public interface EmbeddedCacheContainerConfiguration
extends BasicCacheContainerConfiguration {
    public EmbeddedCacheManager getCacheContainer();

    default public Executor getExecutor() {
        final Executor executor = this.getBlockingManager().asExecutor(this.getClass().getSimpleName());
        return new Executor(){

            @Override
            public void execute(Runnable command) {
                try {
                    executor.execute(command);
                }
                catch (IllegalLifecycleStateException e) {
                    throw new RejectedExecutionException(e);
                }
            }
        };
    }

    default public BlockingManager getBlockingManager() {
        return (BlockingManager)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)this.getCacheContainer(), BlockingManager.class);
    }
}

