/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.persistence;

import java.util.List;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.cache.infinispan.embedded.persistence.FormatterKeyMapper;
import org.wildfly.clustering.marshalling.Formatter;

public class FormatterKeyMapperTestCase {
    @Test
    public void testSinglePadding() {
        FormatterKeyMapper mapper = new FormatterKeyMapper(FormatterKeyMapperTestCase.createPersistenceList(16));
        Assertions.assertThat((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE00)).getClass())).isTrue();
        Assertions.assertThat((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE15)).getClass())).isTrue();
        Assertions.assertThat((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE16)).getClass())).isFalse();
        Assertions.assertThat((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE17)).getClass())).isFalse();
        String result = mapper.getStringMapping((Object)Type.TYPE00);
        Assertions.assertThat((Object)mapper.getKeyMapping(result)).isSameAs((Object)Type.TYPE00);
        Assertions.assertThat((String)result).isEqualTo("0TYPE00");
        result = mapper.getStringMapping((Object)Type.TYPE15);
        Assertions.assertThat((Object)mapper.getKeyMapping(result)).isSameAs((Object)Type.TYPE15);
        Assertions.assertThat((String)result).isEqualTo("FTYPE15");
    }

    @Test
    public void testDoublePadding() {
        FormatterKeyMapper mapper = new FormatterKeyMapper(FormatterKeyMapperTestCase.createPersistenceList(17));
        Assertions.assertThat((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE00)).getClass())).isTrue();
        Assertions.assertThat((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE15)).getClass())).isTrue();
        Assertions.assertThat((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE16)).getClass())).isTrue();
        Assertions.assertThat((boolean)mapper.isSupportedType(((Object)((Object)Type.TYPE17)).getClass())).isFalse();
        String result = mapper.getStringMapping((Object)Type.TYPE00);
        Assertions.assertThat((Object)mapper.getKeyMapping(result)).isSameAs((Object)Type.TYPE00);
        Assertions.assertThat((String)result).isEqualTo("00TYPE00");
        result = mapper.getStringMapping((Object)Type.TYPE15);
        Assertions.assertThat((Object)mapper.getKeyMapping(result)).isSameAs((Object)Type.TYPE15);
        Assertions.assertThat((String)result).isEqualTo("0FTYPE15");
        result = mapper.getStringMapping((Object)Type.TYPE16);
        Assertions.assertThat((Object)mapper.getKeyMapping(result)).isSameAs((Object)Type.TYPE16);
        Assertions.assertThat((String)result).isEqualTo("10TYPE16");
    }

    private static List<? extends Formatter<?>> createPersistenceList(int size) {
        return IntStream.range(0, size).mapToObj(index -> Formatter.IDENTITY.wrap(((Object)((Object)Type.values()[index])).getClass(), Enum::name, value -> Type.valueOf(value))).toList();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Type {
        TYPE00{}
        ,
        TYPE01{}
        ,
        TYPE02{}
        ,
        TYPE03{}
        ,
        TYPE04{}
        ,
        TYPE05{}
        ,
        TYPE06{}
        ,
        TYPE07{}
        ,
        TYPE08{}
        ,
        TYPE09{}
        ,
        TYPE10{}
        ,
        TYPE11{}
        ,
        TYPE12{}
        ,
        TYPE13{}
        ,
        TYPE14{}
        ,
        TYPE15{}
        ,
        TYPE16{}
        ,
        TYPE17{};

    }
}

