/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.cache.CacheEntryMutator;

public class EmbeddedCacheEntryMutator<K, V>
implements CacheEntryMutator {
    private final Cache<K, V> cache;
    private final K key;
    private final V value;
    private final AtomicBoolean mutated;

    public EmbeddedCacheEntryMutator(Cache<K, V> cache, Map.Entry<K, V> entry) {
        this(cache, entry.getKey(), entry.getValue());
    }

    public EmbeddedCacheEntryMutator(Cache<K, V> cache, K key, V value) {
        this.cache = cache;
        this.key = key;
        this.value = value;
        this.mutated = cache.getCacheConfiguration().transaction().transactionMode().isTransactional() ? new AtomicBoolean(false) : null;
    }

    public CompletionStage<Void> mutateAsync() {
        if (this.mutated == null || this.mutated.compareAndSet(false, true)) {
            return this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.FAIL_SILENTLY}).putAsync(this.key, this.value).thenAccept((Consumer)org.wildfly.clustering.function.Consumer.empty());
        }
        return CompletableFuture.completedFuture(null);
    }
}

