/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.context.Flag;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;

public abstract class AbstractAdvancedCache<K, V>
extends AbstractDelegatingAdvancedCache<K, V> {
    private final Metadata defaultMetadata;

    protected AbstractAdvancedCache(AdvancedCache<K, V> cache) {
        super(cache);
        this.defaultMetadata = Configurations.newDefaultMetadata((Configuration)cache.getCacheConfiguration());
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).build();
        return (V)this.compute(key, remappingFunction, metadata);
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).build();
        return (V)this.compute(key, remappingFunction, metadata);
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return (V)this.compute(key, remappingFunction, metadata);
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).build();
        return (V)this.computeIfAbsent(key, mappingFunction, metadata);
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).build();
        return (V)this.computeIfAbsent(key, mappingFunction, metadata);
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return (V)this.computeIfAbsent(key, mappingFunction, metadata);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).build();
        return (V)this.computeIfPresent(key, remappingFunction, metadata);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).build();
        return (V)this.computeIfPresent(key, remappingFunction, metadata);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return (V)this.computeIfPresent(key, remappingFunction, metadata);
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).build();
        return (V)this.merge(key, value, remappingFunction, metadata);
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).build();
        return (V)this.merge(key, value, remappingFunction, metadata);
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return (V)this.merge(key, value, remappingFunction, metadata);
    }

    public V put(K key, V value) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).build();
        return (V)this.put(key, value, metadata);
    }

    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).build();
        return (V)this.put(key, value, metadata);
    }

    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return (V)this.put(key, value, metadata);
    }

    public void putAll(Map<? extends K, ? extends V> entries) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).build();
        this.putAll(entries, metadata);
    }

    public void putAll(Map<? extends K, ? extends V> entries, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).build();
        this.putAll(entries, metadata);
    }

    public void putAll(Map<? extends K, ? extends V> entries, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        this.putAll(entries, metadata);
    }

    public void putForExternalRead(K key, V value) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).build();
        this.putForExternalRead(key, value, metadata);
    }

    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).build();
        this.putForExternalRead(key, value, metadata);
    }

    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        this.putForExternalRead(key, value, metadata);
    }

    public V putIfAbsent(K key, V value) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).build();
        return (V)this.putIfAbsent(key, value, metadata);
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).build();
        return (V)this.putIfAbsent(key, value, metadata);
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return (V)this.putIfAbsent(key, value, metadata);
    }

    public V replace(K key, V value) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).build();
        return (V)this.replace(key, value, metadata);
    }

    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).build();
        return (V)this.replace(key, value, metadata);
    }

    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return (V)this.replace(key, value, metadata);
    }

    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).build();
        return this.computeAsync(key, remappingFunction, metadata);
    }

    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).build();
        return this.computeAsync(key, remappingFunction, metadata);
    }

    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.computeAsync(key, remappingFunction, metadata);
    }

    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).build();
        return this.computeIfAbsentAsync(key, mappingFunction, metadata);
    }

    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).build();
        return this.computeIfAbsentAsync(key, mappingFunction, metadata);
    }

    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.computeIfAbsentAsync(key, mappingFunction, metadata);
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).build();
        return this.computeIfPresentAsync(key, remappingFunction, metadata);
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).build();
        return this.computeIfPresentAsync(key, remappingFunction, metadata);
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.computeIfPresentAsync(key, remappingFunction, metadata);
    }

    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).build();
        return this.mergeAsync(key, value, remappingFunction, metadata);
    }

    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).build();
        return this.mergeAsync(key, value, remappingFunction, metadata);
    }

    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.mergeAsync(key, value, remappingFunction, metadata);
    }

    public CompletableFuture<V> putAsync(K key, V value) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).build();
        return this.putAsync(key, value, metadata);
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).build();
        return this.putAsync(key, value, metadata);
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.putAsync(key, value, metadata);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> entries) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).build();
        return this.putAllAsync(entries, metadata);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> entries, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).build();
        return this.putAllAsync(entries, metadata);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> entries, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.putAllAsync(entries, metadata);
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).build();
        return this.putIfAbsentAsync(key, value, metadata);
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).build();
        return this.putIfAbsentAsync(key, value, metadata);
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.putIfAbsentAsync(key, value, metadata);
    }

    public CompletableFuture<V> replaceAsync(K key, V value) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).build();
        return this.replaceAsync(key, value, metadata);
    }

    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).build();
        return this.replaceAsync(key, value, metadata);
    }

    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().merge(this.defaultMetadata).lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.replaceAsync(key, value, metadata);
    }

    public AdvancedCache<K, V> withFlags(Flag flag) {
        return this.withFlags(EnumSet.of(flag));
    }

    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        return this.withFlags(Set.of(flags));
    }
}

