/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded;

import jakarta.transaction.TransactionManager;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiFunction;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.ThrowingConsumer;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheType;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.event.CacheEntryInvalidatedEvent;
import org.infinispan.persistence.jdbc.common.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.infinispan.util.function.SerializableBiFunction;
import org.infinispan.util.function.SerializableFunction;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheManagerContext;
import org.wildfly.clustering.cache.infinispan.embedded.InvalidationCache;
import org.wildfly.clustering.function.UnaryOperator;

public class InvalidationCacheITCase
extends SoftAssertions {
    private static final String CLUSTER_NAME = "ISPN";
    private static final UnaryOperator<TransactionConfigurationBuilder> NON_TRANSACTIONAL = UnaryOperator.identity();
    private static final UnaryOperator<TransactionConfigurationBuilder> TRANSACTIONAL = builder -> builder.transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup(EmbeddedTransactionManager::getInstance).lockingMode(LockingMode.PESSIMISTIC);

    @Disabled
    @Test
    public void nonTxInvalidation() throws Exception {
        this.test("non-tx", NON_TRANSACTIONAL, (UnaryOperator<Cache<String, Integer>>)UnaryOperator.identity());
    }

    @Test
    public void nonTxInvalidationFixed() throws Exception {
        this.test("non-tx-fixed", NON_TRANSACTIONAL, (UnaryOperator<Cache<String, Integer>>)((UnaryOperator)InvalidationCache::new));
    }

    @Disabled
    @Test
    public void txInvalidation() throws Exception {
        this.test("tx", TRANSACTIONAL, (UnaryOperator<Cache<String, Integer>>)UnaryOperator.identity());
    }

    @Disabled
    @Test
    public void txInvalidationFixed() throws Exception {
        this.test("tx-fixed", TRANSACTIONAL, (UnaryOperator<Cache<String, Integer>>)((UnaryOperator)InvalidationCache::new));
    }

    private void test(String cacheName, UnaryOperator<TransactionConfigurationBuilder> configurator, UnaryOperator<Cache<String, Integer>> transformer) throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        Configuration configuration = ((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((TransactionConfigurationBuilder)configurator.apply((Object)builder.transaction())).clustering().cacheType(CacheType.INVALIDATION).persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).dialect(DatabaseType.H2)).table().createOnStart(true)).tableNamePrefix("ispn")).idColumnName("id")).idColumnType("VARCHAR")).dataColumnName("data")).dataColumnType("VARBINARY")).segmentColumnName("segment")).segmentColumnType("NUMERIC")).timestampColumnName("ts")).timestampColumnType("BIGINT")).simpleConnection().driverClass("org.h2.Driver").connectionUrl("jdbc:h2:mem:test;DB_CLOSE_DELAY=-1").username("sa").password("").shared(true)).build();
        try (EmbeddedCacheManagerContext manager1Context = new EmbeddedCacheManagerContext(CLUSTER_NAME, "member1");){
            EmbeddedCacheManager manager1 = (EmbeddedCacheManager)manager1Context.get();
            manager1.defineConfiguration(cacheName, configuration);
            Cache cache1 = (Cache)transformer.apply((Object)manager1.getCache(cacheName));
            cache1.start();
            try (EmbeddedCacheManagerContext manager2Context = new EmbeddedCacheManagerContext(CLUSTER_NAME, "member2");){
                EmbeddedCacheManager manager2 = (EmbeddedCacheManager)manager2Context.get();
                manager2.defineConfiguration(cacheName, configuration);
                Cache cache2 = (Cache)transformer.apply((Object)manager2.getCache(cacheName));
                cache2.start();
                this.testPut((Cache<String, Integer>)cache1, (Cache<String, Integer>)cache2);
                this.testPutIgnoreReturnValue((Cache<String, Integer>)cache1.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES), (Cache<String, Integer>)cache2.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES));
                this.testCompute((Cache<String, Integer>)cache1, (Cache<String, Integer>)cache2);
                this.testComputeIgnoreReturnValue((Cache<String, Integer>)cache1.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES), (Cache<String, Integer>)cache2.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES));
                this.assertAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPut(Cache<String, Integer> cache1, Cache<String, Integer> cache2) throws Exception {
        TransactionManager tm1 = cache1.getAdvancedCache().getTransactionManager();
        TransactionManager tm2 = cache2.getAdvancedCache().getTransactionManager();
        AdvancedCache skipLoadCache1 = cache1.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
        AdvancedCache skipLoadCache2 = cache2.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
        LinkedBlockingQueue<Map.Entry<String, Boolean>> events1 = new LinkedBlockingQueue<Map.Entry<String, Boolean>>();
        LinkedBlockingQueue<Map.Entry<String, Boolean>> events2 = new LinkedBlockingQueue<Map.Entry<String, Boolean>>();
        InvalidationEventCollector listener1 = new InvalidationEventCollector(events1);
        InvalidationEventCollector listener2 = new InvalidationEventCollector(events2);
        String key = "put";
        cache1.addListener((Object)listener1);
        cache2.addListener((Object)listener2);
        try {
            if (tm1 != null) {
                tm1.begin();
            }
            this.assertThat((Integer)cache1.putIfAbsent((Object)key, (Object)0)).isNull();
            if (tm1 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm1.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isEqualTo(0);
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isNull();
            if (tm2 != null) {
                tm2.begin();
            }
            this.assertThat((Integer)cache2.putIfAbsent((Object)key, (Object)-1)).isEqualTo(0);
            if (tm2 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm2.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isEqualTo(0);
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isEqualTo(0);
            if (tm1 != null) {
                tm1.begin();
            }
            this.assertThat((Integer)cache1.put((Object)key, (Object)1)).isEqualTo(0);
            if (tm1 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm1.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isEqualTo(1);
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isNull();
            if (tm1 != null) {
                tm1.begin();
            }
            this.assertThat((Integer)cache1.put((Object)key, (Object)2)).isEqualTo(1);
            if (tm1 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm1.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isEqualTo(2);
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isNull();
            if (tm2 != null) {
                tm2.begin();
            }
            this.assertThat((Integer)cache2.replace((Object)key, (Object)3)).isEqualTo(2);
            if (tm2 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm2.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events1.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isNull();
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isEqualTo(3);
            if (tm2 != null) {
                tm2.begin();
            }
            this.assertThat((Integer)cache2.replace((Object)key, (Object)4)).isEqualTo(3);
            if (tm2 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm2.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events1.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isNull();
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isEqualTo(4);
            if (tm2 != null) {
                tm2.begin();
            }
            this.assertThat((Integer)cache1.remove((Object)key)).isEqualTo(4);
            if (tm2 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm2.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat(cache1.containsKey((Object)key)).isFalse();
            this.assertThat(cache2.containsKey((Object)key)).isFalse();
        }
        finally {
            cache1.removeListener((Object)listener1);
            cache2.removeListener((Object)listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPutIgnoreReturnValue(Cache<String, Integer> cache1, Cache<String, Integer> cache2) throws Exception {
        TransactionManager tm1 = cache1.getAdvancedCache().getTransactionManager();
        TransactionManager tm2 = cache2.getAdvancedCache().getTransactionManager();
        AdvancedCache skipLoadCache1 = cache1.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
        AdvancedCache skipLoadCache2 = cache2.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
        LinkedBlockingQueue<Map.Entry<String, Boolean>> events1 = new LinkedBlockingQueue<Map.Entry<String, Boolean>>();
        LinkedBlockingQueue<Map.Entry<String, Boolean>> events2 = new LinkedBlockingQueue<Map.Entry<String, Boolean>>();
        InvalidationEventCollector listener1 = new InvalidationEventCollector(events1);
        InvalidationEventCollector listener2 = new InvalidationEventCollector(events2);
        String key = "put-ignore";
        cache1.addListener((Object)listener1);
        cache2.addListener((Object)listener2);
        try {
            if (tm1 != null) {
                tm1.begin();
            }
            this.assertThat((Integer)cache1.putIfAbsent((Object)key, (Object)0)).isNull();
            if (tm1 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm1.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isEqualTo(0);
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isNull();
            if (tm2 != null) {
                tm2.begin();
            }
            this.assertThat((Integer)cache2.putIfAbsent((Object)key, (Object)-1)).satisfiesAnyOf(new ThrowingConsumer[]{result -> this.assertThat((Integer)result).isNull(), result -> this.assertThat((Integer)result).isEqualTo(0)});
            if (tm2 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm2.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isEqualTo(0);
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isEqualTo(0);
            if (tm1 != null) {
                tm1.begin();
            }
            this.assertThat((Integer)cache1.put((Object)key, (Object)1)).satisfiesAnyOf(new ThrowingConsumer[]{result -> this.assertThat((Integer)result).isNull(), result -> this.assertThat((Integer)result).isEqualTo(0)});
            if (tm1 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm1.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isEqualTo(1);
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isNull();
            if (tm1 != null) {
                tm1.begin();
            }
            this.assertThat((Integer)cache1.put((Object)key, (Object)2)).satisfiesAnyOf(new ThrowingConsumer[]{result -> this.assertThat((Integer)result).isNull(), result -> this.assertThat((Integer)result).isEqualTo(1)});
            if (tm1 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm1.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isEqualTo(2);
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isNull();
            if (tm2 != null) {
                tm2.begin();
            }
            this.assertThat((Integer)cache2.replace((Object)key, (Object)3)).satisfiesAnyOf(new ThrowingConsumer[]{result -> this.assertThat((Integer)result).isNull(), result -> this.assertThat((Integer)result).isEqualTo(2)});
            if (tm2 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm2.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events1.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isNull();
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isEqualTo(3);
            if (tm2 != null) {
                tm2.begin();
            }
            this.assertThat((Integer)cache2.replace((Object)key, (Object)4)).satisfiesAnyOf(new ThrowingConsumer[]{result -> this.assertThat((Integer)result).isNull(), result -> this.assertThat((Integer)result).isEqualTo(3)});
            if (tm2 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm2.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events1.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isNull();
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isEqualTo(4);
            if (tm2 != null) {
                tm2.begin();
            }
            this.assertThat((Integer)cache1.remove((Object)key)).satisfiesAnyOf(new ThrowingConsumer[]{result -> this.assertThat((Integer)result).isNull(), result -> this.assertThat((Integer)result).isEqualTo(4)});
            if (tm2 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm2.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat(cache1.containsKey((Object)key)).isFalse();
            this.assertThat(cache2.containsKey((Object)key)).isFalse();
        }
        finally {
            cache1.removeListener((Object)listener1);
            cache2.removeListener((Object)listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCompute(Cache<String, Integer> cache1, Cache<String, Integer> cache2) throws Exception {
        TransactionManager tm1 = cache1.getAdvancedCache().getTransactionManager();
        TransactionManager tm2 = cache2.getAdvancedCache().getTransactionManager();
        AdvancedCache skipLoadCache1 = cache1.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
        AdvancedCache skipLoadCache2 = cache2.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
        LinkedBlockingQueue<Map.Entry<String, Boolean>> events1 = new LinkedBlockingQueue<Map.Entry<String, Boolean>>();
        LinkedBlockingQueue<Map.Entry<String, Boolean>> events2 = new LinkedBlockingQueue<Map.Entry<String, Boolean>>();
        InvalidationEventCollector listener1 = new InvalidationEventCollector(events1);
        InvalidationEventCollector listener2 = new InvalidationEventCollector(events2);
        String key = "compute";
        cache1.addListener((Object)listener1);
        cache2.addListener((Object)listener2);
        try {
            BiFunction<String, Integer, Integer> increment = (k, v) -> v != null ? v + 1 : 0;
            if (tm1 != null) {
                tm1.begin();
            }
            this.assertThat((Integer)cache1.computeIfAbsent((Object)key, (SerializableFunction & Serializable)k -> 0)).isEqualTo(0);
            if (tm1 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm1.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isEqualTo(0);
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isNull();
            if (tm1 != null) {
                tm1.begin();
            }
            this.assertThat((Integer)cache2.computeIfAbsent((Object)key, (SerializableFunction & Serializable)k -> -1)).isEqualTo(0);
            if (tm1 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm1.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isEqualTo(0);
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isEqualTo(0);
            if (tm1 != null) {
                tm1.begin();
            }
            this.assertThat((Integer)cache1.compute((Object)key, increment)).isEqualTo(1);
            if (tm1 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm1.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isEqualTo(1);
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isNull();
            if (tm1 != null) {
                tm1.begin();
            }
            this.assertThat((Integer)cache1.compute((Object)key, increment)).isEqualTo(2);
            if (tm1 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm1.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isEqualTo(2);
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isNull();
            if (tm2 != null) {
                tm2.begin();
            }
            this.assertThat((Integer)cache2.computeIfPresent((Object)key, increment)).isEqualTo(3);
            if (tm2 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm2.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events1.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isNull();
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isEqualTo(3);
            if (tm2 != null) {
                tm2.begin();
            }
            this.assertThat((Integer)cache2.computeIfPresent((Object)key, increment)).isEqualTo(4);
            if (tm2 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm2.commit();
            }
            if (tm1 == null) {
                this.assertThat((Map.Entry)events1.poll()).isEqualTo(Map.entry(key, true));
                this.assertThat((Map.Entry)events1.poll()).isEqualTo(Map.entry(key, false));
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isNull();
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isEqualTo(4);
            if (tm2 != null) {
                tm2.begin();
            }
            this.assertThat((Integer)cache1.computeIfPresent((Object)key, (SerializableBiFunction & Serializable)(k, v) -> null)).isNull();
            if (tm2 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm2.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat(cache1.containsKey((Object)key)).isFalse();
            this.assertThat(cache2.containsKey((Object)key)).isFalse();
        }
        finally {
            cache1.removeListener((Object)listener1);
            cache2.removeListener((Object)listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testComputeIgnoreReturnValue(Cache<String, Integer> cache1, Cache<String, Integer> cache2) throws Exception {
        TransactionManager tm1 = cache1.getAdvancedCache().getTransactionManager();
        TransactionManager tm2 = cache2.getAdvancedCache().getTransactionManager();
        AdvancedCache skipLoadCache1 = cache1.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
        AdvancedCache skipLoadCache2 = cache2.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
        LinkedBlockingQueue<Map.Entry<String, Boolean>> events1 = new LinkedBlockingQueue<Map.Entry<String, Boolean>>();
        LinkedBlockingQueue<Map.Entry<String, Boolean>> events2 = new LinkedBlockingQueue<Map.Entry<String, Boolean>>();
        InvalidationEventCollector listener1 = new InvalidationEventCollector(events1);
        InvalidationEventCollector listener2 = new InvalidationEventCollector(events2);
        String key = "compute-ignore";
        cache1.addListener((Object)listener1);
        cache2.addListener((Object)listener2);
        try {
            BiFunction<String, Integer, Integer> increment = (k, v) -> v != null ? v + 1 : 0;
            if (tm1 != null) {
                tm1.begin();
            }
            this.assertThat((Integer)cache1.computeIfAbsent((Object)key, (SerializableFunction & Serializable)k -> 0)).satisfiesAnyOf(new ThrowingConsumer[]{result -> this.assertThat((Integer)result).isNull(), result -> this.assertThat((Integer)result).isEqualTo(0)});
            if (tm1 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm1.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isEqualTo(0);
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isNull();
            if (tm1 != null) {
                tm1.begin();
            }
            this.assertThat((Integer)cache2.computeIfAbsent((Object)key, (SerializableFunction & Serializable)k -> -1)).satisfiesAnyOf(new ThrowingConsumer[]{result -> this.assertThat((Integer)result).isNull(), result -> this.assertThat((Integer)result).isEqualTo(0)});
            if (tm1 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm1.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isEqualTo(0);
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isEqualTo(0);
            if (tm1 != null) {
                tm1.begin();
            }
            this.assertThat((Integer)cache1.compute((Object)key, increment)).satisfiesAnyOf(new ThrowingConsumer[]{result -> this.assertThat((Integer)result).isNull(), result -> this.assertThat((Integer)result).isEqualTo(1)});
            if (tm1 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm1.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isEqualTo(1);
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isNull();
            if (tm1 != null) {
                tm1.begin();
            }
            this.assertThat((Integer)cache1.compute((Object)key, increment)).satisfiesAnyOf(new ThrowingConsumer[]{result -> this.assertThat((Integer)result).isNull(), result -> this.assertThat((Integer)result).isEqualTo(2)});
            if (tm1 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm1.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isEqualTo(2);
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isNull();
            if (tm2 != null) {
                tm2.begin();
            }
            this.assertThat((Integer)cache2.computeIfPresent((Object)key, increment)).satisfiesAnyOf(new ThrowingConsumer[]{result -> this.assertThat((Integer)result).isNull(), result -> this.assertThat((Integer)result).isEqualTo(3)});
            if (tm2 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm2.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events1.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isNull();
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isEqualTo(3);
            if (tm2 != null) {
                tm2.begin();
            }
            this.assertThat((Integer)cache2.computeIfPresent((Object)key, increment)).satisfiesAnyOf(new ThrowingConsumer[]{result -> this.assertThat((Integer)result).isNull(), result -> this.assertThat((Integer)result).isEqualTo(4)});
            if (tm2 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm2.commit();
            }
            if (tm1 == null) {
                this.assertThat((Map.Entry)events1.poll()).isEqualTo(Map.entry(key, true));
                this.assertThat((Map.Entry)events1.poll()).isEqualTo(Map.entry(key, false));
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat((Integer)skipLoadCache1.get((Object)key)).isNull();
            this.assertThat((Integer)skipLoadCache2.get((Object)key)).isEqualTo(4);
            if (tm2 != null) {
                tm2.begin();
            }
            this.assertThat((Integer)cache1.computeIfPresent((Object)key, (SerializableBiFunction & Serializable)(k, v) -> null)).isNull();
            if (tm2 != null) {
                this.assertThat((Map.Entry)events1.poll()).isNull();
                this.assertThat((Map.Entry)events2.poll()).isNull();
                tm2.commit();
            }
            this.assertThat((Map.Entry)events1.poll()).isNull();
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, true));
            this.assertThat((Map.Entry)events2.poll()).isEqualTo(Map.entry(key, false));
            this.assertThat((Map.Entry)events2.poll()).isNull();
            this.assertThat(cache1.containsKey((Object)key)).isFalse();
            this.assertThat(cache2.containsKey((Object)key)).isFalse();
        }
        finally {
            cache1.removeListener((Object)listener1);
            cache2.removeListener((Object)listener2);
        }
    }

    @Listener
    public class InvalidationEventCollector {
        private final Collection<Map.Entry<String, Boolean>> events;

        InvalidationEventCollector(Collection<Map.Entry<String, Boolean>> events) {
            this.events = events;
        }

        @CacheEntryInvalidated
        public void invalidated(CacheEntryInvalidatedEvent<String, Integer> event) {
            this.events.add(Map.entry((String)event.getKey(), event.isPre()));
        }
    }
}

