/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.affinity;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import org.wildfly.clustering.cache.infinispan.embedded.affinity.DefaultKeyAffinityService;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.KeyDistribution;

public class DefaultKeyAffinityServiceTestCase {
    private static final int SEGMENTS = 3;
    private static final int LOCAL_SEGMENT = 0;
    private static final int REMOTE_SEGMENT = 1;
    private static final int FILTERED_SEGMENT = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        KeyGenerator generator = (KeyGenerator)Mockito.mock(KeyGenerator.class);
        AdvancedCache cache = (AdvancedCache)Mockito.mock(AdvancedCache.class);
        KeyDistribution distribution = (KeyDistribution)Mockito.mock(KeyDistribution.class);
        ConsistentHash hash = (ConsistentHash)Mockito.mock(ConsistentHash.class);
        Address local = (Address)Mockito.mock(Address.class);
        Address remote = (Address)Mockito.mock(Address.class);
        Address standby = (Address)Mockito.mock(Address.class);
        Address ignored = (Address)Mockito.mock(Address.class);
        UUID random = UUID.randomUUID();
        DefaultKeyAffinityService service = new DefaultKeyAffinityService((Cache)cache, generator, address -> address != ignored, c -> hash, (c, h) -> distribution);
        ((KeyGenerator)Mockito.doReturn((Object)random).when((Object)generator)).getKey();
        Assertions.assertThat((Comparable)((UUID)service.getKeyForAddress(local))).isSameAs((Object)random);
        Assertions.assertThat((Comparable)((UUID)service.getKeyForAddress(remote))).isSameAs((Object)random);
        Assertions.assertThat((Comparable)((UUID)service.getKeyForAddress(standby))).isSameAs((Object)random);
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> DefaultKeyAffinityServiceTestCase.lambda$test$3((KeyAffinityService)service, ignored));
        List<Address> members = List.of(local, remote, ignored, standby);
        Mockito.when((Object)hash.getMembers()).thenReturn(members);
        Mockito.when((Object)hash.getPrimarySegmentsForOwner(local)).thenReturn(Set.of(Integer.valueOf(0)));
        Mockito.when((Object)hash.getPrimarySegmentsForOwner(remote)).thenReturn(Set.of(Integer.valueOf(1)));
        Mockito.when((Object)hash.getPrimarySegmentsForOwner(standby)).thenReturn(Set.of());
        Mockito.when((Object)hash.getPrimarySegmentsForOwner(ignored)).thenReturn(Set.of(Integer.valueOf(2)));
        int[] keysPerSegment = new int[3];
        Arrays.fill(keysPerSegment, 0);
        int minKeysPerSegment = 300;
        IntPredicate needMoreKeys = keys -> keys < minKeysPerSegment;
        OngoingStubbing stub = Mockito.when((Object)((UUID)generator.getKey()));
        while (IntStream.of(keysPerSegment).anyMatch(needMoreKeys)) {
            int segment;
            UUID key = UUID.randomUUID();
            int n = segment = DefaultKeyAffinityServiceTestCase.getSegment(key);
            keysPerSegment[n] = keysPerSegment[n] + 1;
            stub = stub.thenReturn((Object)key);
            Mockito.when((Object)distribution.getPrimaryOwner((Object)key)).thenReturn((Object)members.get(segment));
        }
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> DefaultKeyAffinityServiceTestCase.lambda$test$5((KeyAffinityService)service, ignored));
        service.start();
        try {
            int iterations = 50;
            for (int i = 0; i < iterations; ++i) {
                UUID key = (UUID)service.getKeyForAddress(local);
                int segment = DefaultKeyAffinityServiceTestCase.getSegment(key);
                Assertions.assertThat((int)segment).isEqualTo(0);
                key = (UUID)service.getCollocatedKey((Object)key);
                segment = DefaultKeyAffinityServiceTestCase.getSegment(key);
                Assertions.assertThat((int)segment).isEqualTo(0);
                key = (UUID)service.getKeyForAddress(remote);
                segment = DefaultKeyAffinityServiceTestCase.getSegment(key);
                Assertions.assertThat((int)segment).isEqualTo(1);
                key = (UUID)service.getCollocatedKey((Object)key);
                segment = DefaultKeyAffinityServiceTestCase.getSegment(key);
                Assertions.assertThat((int)segment).isEqualTo(1);
            }
            Assertions.assertThat((Comparable)((UUID)service.getKeyForAddress(standby))).isNotNull();
            Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> DefaultKeyAffinityServiceTestCase.lambda$test$6((KeyAffinityService)service, ignored));
        }
        finally {
            service.stop();
        }
    }

    private static int getSegment(UUID key) {
        return Math.abs(key.hashCode()) % 3;
    }

    private static /* synthetic */ void lambda$test$6(KeyAffinityService service, Address ignored) throws Throwable {
        service.getKeyForAddress(ignored);
    }

    private static /* synthetic */ void lambda$test$5(KeyAffinityService service, Address ignored) throws Throwable {
        service.getKeyForAddress(ignored);
    }

    private static /* synthetic */ void lambda$test$3(KeyAffinityService service, Address ignored) throws Throwable {
        service.getKeyForAddress(ignored);
    }
}

