/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.container;

import java.util.function.Supplier;
import org.infinispan.commons.util.ByteQuantity;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.impl.BoundedSegmentedDataContainer;
import org.infinispan.container.impl.DefaultDataContainer;
import org.infinispan.container.impl.DefaultSegmentedDataContainer;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.L1SegmentedDataContainer;
import org.infinispan.container.impl.PeekableTouchableContainerMap;
import org.infinispan.container.impl.PeekableTouchableMap;
import org.infinispan.container.offheap.BoundedOffHeapDataContainer;
import org.infinispan.container.offheap.OffHeapConcurrentMap;
import org.infinispan.container.offheap.OffHeapDataContainer;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.offheap.SegmentedBoundedOffHeapDataContainer;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.wildfly.clustering.cache.infinispan.embedded.container.EvictableDataContainer;
import org.wildfly.clustering.cache.infinispan.embedded.container.SegmentedEvictableDataContainer;

@DefaultFactoryFor(classes={InternalDataContainer.class})
@SurvivesRestarts
public class DataContainerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    public Object construct(String componentName) {
        DataContainer<?, ?> container = this.createDataContainer();
        MemoryConfiguration memory = this.configuration.memory();
        memory.attributes().attribute(MemoryConfiguration.MAX_SIZE).addListener((newSize, oldSize) -> container.resize(ByteQuantity.parse((String)((String)newSize.get()))));
        memory.attributes().attribute(MemoryConfiguration.MAX_COUNT).addListener((newSize, oldSize) -> container.resize(((Long)newSize.get()).longValue()));
        return container;
    }

    private DataContainer<?, ?> createDataContainer() {
        boolean hasSize;
        MemoryConfiguration memory = this.configuration.memory();
        ClusteringConfiguration clustering = this.configuration.clustering();
        EvictionStrategy strategy = memory.whenFull();
        boolean segmented = clustering.cacheMode().needsStateTransfer();
        int segments = clustering.hash().numSegments();
        boolean offHeap = this.configuration.memory().isOffHeap();
        if (strategy.isExceptionBased() || !strategy.isEnabled()) {
            if (segmented) {
                Supplier<PeekableTouchableMap> factory = offHeap ? this::createAndStartOffHeapConcurrentMap : PeekableTouchableContainerMap::new;
                return clustering.l1().enabled() ? new L1SegmentedDataContainer(factory, segments) : new DefaultSegmentedDataContainer(factory, segments);
            }
            return offHeap ? new OffHeapDataContainer() : DefaultDataContainer.unBoundedDataContainer((int)this.configuration.locking().concurrencyLevel());
        }
        boolean bl = hasSize = memory.maxSize() != null;
        if (offHeap) {
            return segmented ? new SegmentedBoundedOffHeapDataContainer(segments, memory.maxCount(), hasSize) : new BoundedOffHeapDataContainer(memory.maxCount(), hasSize);
        }
        if (hasSize) {
            return segmented ? new BoundedSegmentedDataContainer(segments, memory.maxSizeBytes(), hasSize) : DefaultDataContainer.boundedDataContainer((int)this.configuration.locking().concurrencyLevel(), (long)memory.maxSizeBytes(), (boolean)hasSize);
        }
        return segmented ? new SegmentedEvictableDataContainer(this.basicComponentRegistry, this.configuration) : new EvictableDataContainer(this.basicComponentRegistry, this.configuration);
    }

    private OffHeapConcurrentMap createAndStartOffHeapConcurrentMap() {
        OffHeapEntryFactory entryFactory = (OffHeapEntryFactory)this.basicComponentRegistry.getComponent(OffHeapEntryFactory.class).wired();
        OffHeapMemoryAllocator memoryAllocator = (OffHeapMemoryAllocator)this.basicComponentRegistry.getComponent(OffHeapMemoryAllocator.class).wired();
        return new OffHeapConcurrentMap(memoryAllocator, entryFactory, null);
    }
}

