/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded;

import jakarta.transaction.TransactionManager;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheCollection;
import org.infinispan.CachePublisher;
import org.infinispan.CacheSet;
import org.infinispan.LockedStream;
import org.infinispan.batch.BatchContainer;
import org.infinispan.cache.impl.InternalCache;
import org.infinispan.commons.api.query.ContinuousQuery;
import org.infinispan.commons.api.query.Query;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.encoding.DataConversion;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.stats.Stats;
import org.infinispan.util.concurrent.locks.LockManager;
import org.wildfly.clustering.cache.infinispan.NonBlockingBasicCacheDecorator;

public class AdvancedCacheDecorator<K, V>
extends NonBlockingBasicCacheDecorator<K, V>
implements AdvancedCache<K, V>,
InternalCache<K, V> {
    private final AdvancedCache<K, V> cache;
    private final InternalCache<K, V> internalCache;
    private final UnaryOperator<AdvancedCache<K, V>> decorator;
    private final Metadata defaultMetadata;

    protected AdvancedCacheDecorator(AdvancedCache<K, V> cache, UnaryOperator<AdvancedCache<K, V>> decorator) {
        super(cache);
        this.cache = cache;
        this.internalCache = (InternalCache)cache;
        this.decorator = decorator;
        this.defaultMetadata = Configurations.newDefaultMetadata((Configuration)cache.getCacheConfiguration());
    }

    public ComponentRegistry getComponentRegistry() {
        return this.internalCache.getComponentRegistry();
    }

    public boolean bypassInvocationContextFactory() {
        return this.internalCache.bypassInvocationContextFactory();
    }

    public Configuration getCacheConfiguration() {
        return this.cache.getCacheConfiguration();
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cache.getCacheManager();
    }

    public AdvancedCache<K, V> getAdvancedCache() {
        return this;
    }

    public AvailabilityMode getAvailability() {
        return this.cache.getAvailability();
    }

    public void setAvailability(AvailabilityMode availabilityMode) {
        this.cache.setAvailability(availabilityMode);
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.cache.getAuthorizationManager();
    }

    public BatchContainer getBatchContainer() {
        return this.cache.getBatchContainer();
    }

    public ClassLoader getClassLoader() {
        return this.cache.getClassLoader();
    }

    public ComponentStatus getStatus() {
        return this.cache.getStatus();
    }

    public DataContainer<K, V> getDataContainer() {
        return this.cache.getDataContainer();
    }

    public DataConversion getKeyDataConversion() {
        return this.cache.getKeyDataConversion();
    }

    public DataConversion getValueDataConversion() {
        return this.cache.getValueDataConversion();
    }

    public DistributionManager getDistributionManager() {
        return this.cache.getDistributionManager();
    }

    public ExpirationManager<K, V> getExpirationManager() {
        return this.cache.getExpirationManager();
    }

    public LockManager getLockManager() {
        return this.cache.getLockManager();
    }

    public RpcManager getRpcManager() {
        return this.cache.getRpcManager();
    }

    public Stats getStats() {
        return this.cache.getStats();
    }

    public TransactionManager getTransactionManager() {
        return this.cache.getTransactionManager();
    }

    public XAResource getXAResource() {
        return this.cache.getXAResource();
    }

    public AdvancedCache<K, V> lockAs(Object lockOwner) {
        return (AdvancedCache)this.decorator.apply(this.cache.lockAs(lockOwner));
    }

    public AdvancedCache<K, V> noFlags() {
        return (AdvancedCache)this.decorator.apply(this.cache.noFlags());
    }

    public AdvancedCache<K, V> transform(Function<AdvancedCache<K, V>, ? extends AdvancedCache<K, V>> transformation) {
        return (AdvancedCache)this.decorator.apply(this.cache.transform(transformation));
    }

    public AdvancedCache<K, V> withFlags(Flag flag) {
        return (AdvancedCache)this.decorator.apply(this.cache.withFlags(flag));
    }

    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        return (AdvancedCache)this.decorator.apply(this.cache.withFlags(flags));
    }

    public AdvancedCache<K, V> withFlags(Collection<Flag> flags) {
        return (AdvancedCache)this.decorator.apply(this.cache.withFlags(flags));
    }

    public <K1, V1> AdvancedCache<K1, V1> withMediaType(MediaType keyMediaType, MediaType valueMediaType) {
        return (AdvancedCache)this.decorator.apply(this.cache.withMediaType(keyMediaType, valueMediaType));
    }

    public AdvancedCache<K, V> withStorageMediaType() {
        return (AdvancedCache)this.decorator.apply(this.cache.withStorageMediaType());
    }

    public AdvancedCache<K, V> withSubject(Subject subject) {
        return (AdvancedCache)this.decorator.apply(this.cache.withSubject(subject));
    }

    public CachePublisher<K, V> cachePublisher() {
        return this.cache.cachePublisher();
    }

    public CacheSet<CacheEntry<K, V>> cacheEntrySet() {
        return this.cache.cacheEntrySet();
    }

    public CacheSet<Map.Entry<K, V>> entrySet() {
        return this.cache.entrySet();
    }

    public CacheSet<K> keySet() {
        return this.cache.keySet();
    }

    public LockedStream<K, V> lockedStream() {
        return this.cache.lockedStream();
    }

    public CacheCollection<V> values() {
        return this.cache.values();
    }

    public void clear() {
        this.cache.clear();
    }

    public CompletableFuture<Void> clearAsync() {
        return this.cache.clearAsync();
    }

    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    public CompletableFuture<Boolean> containsKeyAsync(K key) {
        return this.cache.containsKeyAsync(key);
    }

    public boolean containsValue(Object value) {
        return this.cache.containsValue(value);
    }

    public int size() {
        return this.cache.size();
    }

    public CompletableFuture<Long> sizeAsync() {
        return this.cache.sizeAsync();
    }

    public V getOrDefault(Object key, V defaultValue) {
        return (V)this.cache.getOrDefault(key, defaultValue);
    }

    public CompletableFuture<Map<K, V>> getAllAsync(Set<?> keys) {
        return this.cache.getAllAsync(keys);
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.compute(key, remappingFunction, this.defaultMetadata);
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.compute(key, remappingFunction, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle()).build());
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.compute(key, remappingFunction, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build());
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return (V)this.cache.compute(key, remappingFunction, metadata);
    }

    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeAsync(key, remappingFunction, this.defaultMetadata);
    }

    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.computeAsync(key, remappingFunction, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle()).build());
    }

    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.computeAsync(key, remappingFunction, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build());
    }

    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.cache.computeAsync(key, remappingFunction, metadata);
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIfAbsent(key, mappingFunction, this.defaultMetadata);
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.computeIfAbsent(key, mappingFunction, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle()).build());
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.computeIfAbsent(key, mappingFunction, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build());
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata) {
        return (V)this.cache.computeIfAbsent(key, mappingFunction, metadata);
    }

    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIfAbsentAsync(key, mappingFunction, this.defaultMetadata);
    }

    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.computeIfAbsentAsync(key, mappingFunction, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle()).build());
    }

    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.computeIfAbsentAsync(key, mappingFunction, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build());
    }

    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata) {
        return this.cache.computeIfAbsentAsync(key, mappingFunction, metadata);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeIfPresent(key, remappingFunction, this.defaultMetadata);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.computeIfPresent(key, remappingFunction, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle()).build());
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.computeIfPresent(key, remappingFunction, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build());
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return (V)this.cache.computeIfPresent(key, remappingFunction, metadata);
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeIfPresentAsync(key, remappingFunction, this.defaultMetadata);
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.computeIfPresentAsync(key, remappingFunction, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle()).build());
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.computeIfPresentAsync(key, remappingFunction, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build());
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.cache.computeIfPresentAsync(key, remappingFunction, metadata);
    }

    public Map<K, V> getAll(Set<?> keys) {
        return this.cache.getAll(keys);
    }

    public boolean lock(K ... keys) {
        return this.lock((Collection<? extends K>)Set.of(keys));
    }

    public boolean lock(Collection<? extends K> keys) {
        return this.cache.lock(keys);
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.merge(key, value, remappingFunction, this.defaultMetadata);
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.merge(key, value, remappingFunction, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle()).build());
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.merge(key, value, remappingFunction, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build());
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return (V)this.cache.merge(key, value, remappingFunction, metadata);
    }

    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.mergeAsync(key, value, remappingFunction, this.defaultMetadata);
    }

    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.mergeAsync(key, value, remappingFunction, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle()).build());
    }

    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.mergeAsync(key, value, remappingFunction, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build());
    }

    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.cache.mergeAsync(key, value, remappingFunction, metadata);
    }

    public V put(K key, V value) {
        return this.put(key, value, this.defaultMetadata);
    }

    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        return this.put(key, value, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle()).build());
    }

    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.put(key, value, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build());
    }

    public V put(K key, V value, Metadata metadata) {
        return (V)this.cache.put(key, value, metadata);
    }

    public CompletableFuture<V> putAsync(K key, V value) {
        return this.putAsync(key, value, this.defaultMetadata);
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        return this.putAsync(key, value, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle()).build());
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.putAsync(key, value, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build());
    }

    public CompletableFuture<V> putAsync(K key, V value, Metadata metadata) {
        return this.cache.putAsync(key, value, metadata);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAll(map, this.defaultMetadata);
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit) {
        this.putAll(map, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle()).build());
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.putAll(map, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build());
    }

    public void putAll(Map<? extends K, ? extends V> map, Metadata metadata) {
        this.cache.putAll(map, metadata);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return this.putAllAsync(data, this.defaultMetadata);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit) {
        return this.putAllAsync(data, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle()).build());
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.putAllAsync(data, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build());
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, Metadata metadata) {
        return this.cache.putAllAsync(map, metadata);
    }

    public void putForExternalRead(K key, V value) {
        this.putForExternalRead(key, value, this.defaultMetadata);
    }

    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        this.putForExternalRead(key, value, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle()).build());
    }

    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.putForExternalRead(key, value, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build());
    }

    public void putForExternalRead(K key, V value, Metadata metadata) {
        this.cache.putForExternalRead(key, value, metadata);
    }

    public V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, this.defaultMetadata);
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        return this.putIfAbsent(key, value, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle()).build());
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.putIfAbsent(key, value, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build());
    }

    public V putIfAbsent(K key, V value, Metadata metadata) {
        return (V)this.cache.putIfAbsent(key, value, metadata);
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value) {
        return this.putIfAbsentAsync(key, value, this.defaultMetadata);
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        return this.putIfAbsentAsync(key, value, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle()).build());
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.putIfAbsentAsync(key, value, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build());
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, Metadata metadata) {
        return this.cache.putIfAbsentAsync(key, value, metadata);
    }

    public V replace(K key, V value) {
        return this.replace(key, value, this.defaultMetadata);
    }

    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        return this.replace(key, value, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle()).build());
    }

    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.replace(key, value, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build());
    }

    public V replace(K key, V value, Metadata metadata) {
        return (V)this.cache.replace(key, value, metadata);
    }

    public CompletableFuture<V> replaceAsync(K key, V value) {
        return this.replaceAsync(key, value, (V)this.defaultMetadata);
    }

    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        return this.replaceAsync(key, value, (V)new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle()).build());
    }

    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        return this.replaceAsync(key, value, (V)new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleUnit).build());
    }

    public CompletableFuture<V> replaceAsync(K key, V value, Metadata metadata) {
        return this.cache.replaceAsync(key, value, metadata);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.replace(key, oldValue, newValue, this.defaultMetadata);
    }

    public boolean replace(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit) {
        return this.replace(key, oldValue, newValue, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle()).build());
    }

    public boolean replace(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.replace(key, oldValue, newValue, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build());
    }

    public boolean replace(K key, V oldValue, V newValue, Metadata metadata) {
        return this.cache.replace(key, oldValue, newValue, metadata);
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.replaceAsync(key, oldValue, newValue, this.defaultMetadata);
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit) {
        return this.replaceAsync(key, oldValue, newValue, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle()).build());
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.replaceAsync(key, oldValue, newValue, new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build());
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, Metadata metadata) {
        return this.cache.replaceAsync(key, oldValue, newValue, metadata);
    }

    public void evict(K key) {
        this.cache.evict(key);
    }

    public CompletableFuture<Boolean> removeLifespanExpired(K key, V value, Long lifespan) {
        return this.cache.removeLifespanExpired(key, value, lifespan);
    }

    public CompletableFuture<Boolean> removeMaxIdleExpired(K key, V value) {
        return this.cache.removeMaxIdleExpired(key, value);
    }

    public CompletionStage<Boolean> touch(Object key, boolean touchEvenIfExpired) {
        return this.cache.touch(key, touchEvenIfExpired);
    }

    public CompletionStage<Boolean> touch(Object key, int segment, boolean touchEvenIfExpired) {
        return this.cache.touch(key, segment, touchEvenIfExpired);
    }

    public CacheEntry<K, V> getCacheEntry(Object key) {
        return this.cache.getCacheEntry(key);
    }

    public Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys) {
        return this.cache.getAllCacheEntries(keys);
    }

    public CompletableFuture<CacheEntry<K, V>> getCacheEntryAsync(Object key) {
        return this.cache.getCacheEntryAsync(key);
    }

    public CompletableFuture<CacheEntry<K, V>> putAsyncEntry(K key, V value, Metadata metadata) {
        return this.cache.putAsyncEntry(key, value, metadata);
    }

    public CompletableFuture<CacheEntry<K, V>> putIfAbsentAsyncEntry(K key, V value, Metadata metadata) {
        return this.cache.putIfAbsentAsyncEntry(key, value, metadata);
    }

    public CompletableFuture<CacheEntry<K, V>> replaceAsyncEntry(K key, V value, Metadata metadata) {
        return this.cache.replaceAsyncEntry(key, value, metadata);
    }

    public CompletableFuture<CacheEntry<K, V>> removeAsyncEntry(Object key) {
        return this.cache.removeAsyncEntry(key);
    }

    public boolean startBatch() {
        return this.cache.startBatch();
    }

    public void endBatch(boolean successful) {
        this.cache.endBatch(successful);
    }

    public Map<K, V> getGroup(String groupName) {
        return this.cache.getGroup(groupName);
    }

    public void removeGroup(String groupName) {
        this.cache.removeGroup(groupName);
    }

    public <C> CompletionStage<Void> addListenerAsync(final Object listener, final CacheEventFilter<? super K, ? super V> filter, final CacheEventConverter<? super K, ? super V, C> converter) {
        final AdvancedCache<K, V> cache = this.cache;
        return AccessController.doPrivileged(new PrivilegedAction<CompletionStage<Void>>(this){
            final /* synthetic */ AdvancedCacheDecorator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public CompletionStage<Void> run() {
                return cache.addListenerAsync(listener, filter, converter);
            }
        });
    }

    public <C> CompletionStage<Void> addFilteredListenerAsync(final Object listener, final CacheEventFilter<? super K, ? super V> filter, final CacheEventConverter<? super K, ? super V, C> converter, final Set<Class<? extends Annotation>> filterAnnotations) {
        final AdvancedCache<K, V> cache = this.cache;
        return AccessController.doPrivileged(new PrivilegedAction<CompletionStage<Void>>(this){
            final /* synthetic */ AdvancedCacheDecorator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public CompletionStage<Void> run() {
                return cache.addFilteredListenerAsync(listener, filter, converter, filterAnnotations);
            }
        });
    }

    public <C> CompletionStage<Void> addStorageFormatFilteredListenerAsync(final Object listener, final CacheEventFilter<? super K, ? super V> filter, final CacheEventConverter<? super K, ? super V, C> converter, final Set<Class<? extends Annotation>> filterAnnotations) {
        final AdvancedCache<K, V> cache = this.cache;
        return AccessController.doPrivileged(new PrivilegedAction<CompletionStage<Void>>(this){
            final /* synthetic */ AdvancedCacheDecorator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public CompletionStage<Void> run() {
                return cache.addStorageFormatFilteredListenerAsync(listener, filter, converter, filterAnnotations);
            }
        });
    }

    public CompletionStage<Void> addListenerAsync(final Object listener) {
        final AdvancedCache<K, V> cache = this.cache;
        return AccessController.doPrivileged(new PrivilegedAction<CompletionStage<Void>>(this){
            final /* synthetic */ AdvancedCacheDecorator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public CompletionStage<Void> run() {
                return cache.addListenerAsync(listener);
            }
        });
    }

    public CompletionStage<Void> removeListenerAsync(Object listener) {
        return this.cache.removeListenerAsync(listener);
    }

    public <T> Query<T> query(String query) {
        return this.cache.query(query);
    }

    public ContinuousQuery<K, V> continuousQuery() {
        return this.cache.continuousQuery();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AdvancedCache)) {
            return false;
        }
        AdvancedCache cache = (AdvancedCache)object;
        return this.getCacheManager().equals((Object)cache.getCacheManager()) && super.equals(object);
    }
}

