/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.concurrent.BlockingManager;
import org.wildfly.clustering.cache.infinispan.BasicCacheContainerConfiguration;

public interface EmbeddedCacheContainerConfiguration
extends BasicCacheContainerConfiguration {
    public static EmbeddedCacheContainerConfiguration of(final EmbeddedCacheManager container) {
        return new EmbeddedCacheContainerConfiguration(){

            @Override
            public EmbeddedCacheManager getCacheContainer() {
                return container;
            }
        };
    }

    public EmbeddedCacheManager getCacheContainer();

    default public String getName() {
        return this.getCacheContainer().getCacheManagerConfiguration().cacheManagerName();
    }

    default public Executor getExecutor() {
        final Executor executor = ((BlockingManager)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)this.getCacheContainer(), BlockingManager.class)).asExecutor(this.getClass().getSimpleName());
        return new Executor(){
            final /* synthetic */ EmbeddedCacheContainerConfiguration this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void execute(Runnable command) {
                try {
                    executor.execute(command);
                }
                catch (IllegalLifecycleStateException e) {
                    throw new RejectedExecutionException(e);
                }
            }
        };
    }
}

