/*
 * Copyright The WildFly Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package org.wildfly.clustering.cache.infinispan.embedded.distribution;

import org.infinispan.configuration.cache.Configurations;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.SingleSegmentKeyPartitioner;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.wildfly.clustering.cache.Key;

/**
 * Custom key partitioner factory that uses the same key partitioner for all clustered caches, including non-tx invalidation caches.
 * @author Paul Ferraro
 */
@DefaultFactoryFor(classes = KeyPartitioner.class)
public class KeyPartitionerFactory extends AbstractNamedCacheComponentFactory implements AutoInstantiableFactory {
	/**
	 * Creates a key partitioner factory.
	 */
	public KeyPartitionerFactory() {
	}

	@Override
	public Object construct(String componentName) {
		if (!Configurations.needSegments(this.configuration)) {
			return SingleSegmentKeyPartitioner.getInstance();
		}
		HashConfiguration hashConfiguration = this.configuration.clustering().hash();
		KeyPartitioner partitioner = hashConfiguration.keyPartitioner();
		partitioner.init(hashConfiguration);

		this.basicComponentRegistry.wireDependencies(partitioner, false);

		return new KeyPartitioner() {
			@Override
			public int getSegment(Object object) {
				// Co-locate keys with the same ID
				return partitioner.getSegment((object instanceof Key key) ? key.getId() : object);
			}
		};
	}
}
