/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheType;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheManagerContext;
import org.wildfly.clustering.cache.infinispan.embedded.container.DataContainerConfigurationBuilder;

public class EvictionCacheITCase {
    private static final String CLUSTER_NAME = "ISPN";
    private static final int CAPACITY = 10;
    private static final Duration IDLE_THRESHOLD = Duration.ofSeconds(1L);
    private static final Class<?> EVICTABLE = Integer.class;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=CacheType.class)
    public void test(CacheType type) {
        String cacheName = type.name();
        int excess = 10;
        int size = 10 + excess;
        ArrayList<Map.Entry<String, String>> nonEvictable = new ArrayList<Map.Entry<String, String>>(10);
        for (int i = 0; i < 10; ++i) {
            nonEvictable.add(Map.entry(Integer.toString(i), Integer.toString(i)));
        }
        ArrayList<Map.Entry<Integer, String>> evictable = new ArrayList<Map.Entry<Integer, String>>(size);
        for (int i = 0; i < size; ++i) {
            evictable.add(Map.entry(i, Integer.toString(i)));
        }
        ConfigurationBuilder builder = new ConfigurationBuilder();
        DataContainerConfigurationBuilder containerBuilder = (DataContainerConfigurationBuilder)builder.addModule(DataContainerConfigurationBuilder.class);
        containerBuilder.evictable(EVICTABLE::isInstance).idleTimeout(IDLE_THRESHOLD);
        Configuration configuration = builder.clustering().cacheType(type).memory().maxCount(10L).whenFull(EvictionStrategy.REMOVE).build();
        try (EmbeddedCacheManagerContext context = new EmbeddedCacheManagerContext(CLUSTER_NAME, "member1");){
            EmbeddedCacheManager manager = (EmbeddedCacheManager)context.get();
            manager.defineConfiguration(cacheName, configuration);
            Cache cache = manager.getCache(cacheName);
            cache.start();
            LinkedBlockingDeque entries = new LinkedBlockingDeque();
            EvictionEventListener listener = new EvictionEventListener(entries);
            cache.addListener(listener);
            try {
                for (Map.Entry entry : evictable.subList(0, excess)) {
                    cache.put(entry.getKey(), (Object)((String)entry.getValue()));
                }
                Assertions.assertThat(entries).isEmpty();
                for (Map.Entry entry : nonEvictable) {
                    cache.put(entry.getKey(), (Object)((String)entry.getValue()));
                }
                Assertions.assertThat(entries).isEmpty();
                Instant start = Instant.now();
                for (Map.Entry entry3 : evictable.subList(excess, size)) {
                    cache.put(entry3.getKey(), (Object)((String)entry3.getValue()));
                }
                Instant instant = Instant.now().plus(IDLE_THRESHOLD).plus(IDLE_THRESHOLD);
                for (int i = 0; i < excess; ++i) {
                    Map.Entry entry = (Map.Entry)entries.poll();
                    Assertions.assertThat((Object)entry).isNotNull();
                    Assertions.assertThat(entry.getKey()).isInstanceOf(EVICTABLE);
                }
                Assertions.assertThat((Object)((Map.Entry)entries.poll())).isNull();
                for (Map.Entry entry : nonEvictable) {
                    Assertions.assertThat((String)((String)cache.remove(entry.getKey()))).isSameAs(entry.getValue());
                }
                for (int i = 0; i < 10; ++i) {
                    Map.Entry entry = (Map.Entry)entries.poll(Duration.between(Instant.now(), instant).toNanos(), TimeUnit.NANOSECONDS);
                    Assertions.assertThat((Object)entry).isNotNull();
                    Assertions.assertThat(entry.getKey()).isInstanceOf(EVICTABLE);
                    if (i != 0) continue;
                    Assertions.assertThat((Duration)Duration.between(start, Instant.now())).isGreaterThanOrEqualTo((Comparable)IDLE_THRESHOLD);
                }
                Assertions.assertThat((Object)((Map.Entry)entries.poll())).isNull();
                for (Map.Entry entry : evictable) {
                    Assertions.assertThat((String)((String)cache.get(entry.getKey()))).isNull();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                cache.addListener(listener);
                cache.stop();
            }
        }
    }

    @Listener
    private class EvictionEventListener<K, V> {
        private final Queue<Map.Entry<K, V>> entries;

        EvictionEventListener(Queue<Map.Entry<K, V>> entries) {
            this.entries = entries;
        }

        @CacheEntriesEvicted
        public void cacheEntriesEvicted(CacheEntriesEvictedEvent<K, V> event) {
            if (!event.isPre()) {
                event.getEntries().entrySet().forEach(this.entries::add);
            }
        }
    }
}

