/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded.persistence;

import java.util.function.BiConsumer;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableTypeAssert;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.TesterFactory;

public interface FormatterTesterFactory
extends TesterFactory {
    public static final System.Logger LOGGER = System.getLogger(FormatterTesterFactory.class.getName());

    default public <T> Tester<T> createTester(final BiConsumer<T, T> assertion) {
        final TwoWayKey2StringMapper mapper = this.getMapper();
        return new Tester<T>(this){
            final /* synthetic */ FormatterTesterFactory this$0;
            {
                this.this$0 = this$0;
            }

            public T apply(T key) {
                Class<?> keyClass = key.getClass();
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)mapper.isSupportedType(keyClass)).as(key::toString)).isTrue();
                String string = mapper.getStringMapping(key);
                LOGGER.log(System.Logger.Level.DEBUG, "{0}\t{1}\t{2}\t{3}", mapper.getClass().getSimpleName(), keyClass.getCanonicalName(), key, string);
                Object remappedKey = mapper.getKeyMapping(string);
                assertion.accept(key, remappedKey);
                return remappedKey;
            }

            public void reject(T key) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)mapper.isSupportedType(key.getClass())).as(key::toString)).isFalse();
            }

            public <E extends Throwable> void reject(T key, Class<E> expected) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)mapper.isSupportedType(key.getClass())).as(key::toString)).isTrue();
                ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(expected).as(key::toString)).isThrownBy(() -> mapper.getStringMapping(key));
            }
        };
    }

    public TwoWayKey2StringMapper getMapper();
}

