/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.persistence.remote;

import java.util.function.Consumer;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.transaction.lookup.RemoteTransactionManagerLookup;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.wildfly.clustering.cache.infinispan.persistence.remote.RemoteCacheStore;
import org.wildfly.clustering.cache.infinispan.persistence.remote.RemoteCacheStoreConfigurationBuilder;

@BuiltBy(value=RemoteCacheStoreConfigurationBuilder.class)
@ConfigurationFor(value=RemoteCacheStore.class)
public class RemoteCacheStoreConfiguration
extends AbstractStoreConfiguration<RemoteCacheStoreConfiguration>
implements Consumer<RemoteCacheConfigurationBuilder> {
    static final AttributeDefinition<RemoteCacheContainer> CONTAINER = AttributeDefinition.builder((String)"container", null, RemoteCacheContainer.class).build();
    static final AttributeDefinition<String> TEMPLATE = AttributeDefinition.builder((String)"template", null, String.class).build();
    static final AttributeDefinition<String> CONFIGURATION = AttributeDefinition.builder((String)"configuration", (Object)"{\n\t\"distributed-cache\": {\n\t\t\"encoding\" : {\n\t\t\t\"key\" : {\n\t\t\t\t\"media-type\" : \"application/octet-stream\"\n\t\t\t},\n\t\t\t\"value\" : {\n\t\t\t\t\"media-type\" : \"application/octet-stream\"\n\t\t\t}\n\t\t},\n\t\t\"mode\" : \"SYNC\",\n\t\t\"transaction\" : {\n\t\t\t\"mode\" : \"NON_XA\",\n\t\t\t\"locking\" : \"PESSIMISTIC\"\n\t\t}\n\t}\n}", String.class).build();

    public RemoteCacheStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async) {
        super((Enum)Element.HOTROD_STORE, attributes, async, new ConfigurationElement[0]);
    }

    public RemoteCacheContainer container() {
        return (RemoteCacheContainer)this.attributes.attribute(CONTAINER).get();
    }

    public String configuration() {
        return (String)this.attributes.attribute(CONFIGURATION).get();
    }

    public String template() {
        return (String)this.attributes.attribute(TEMPLATE).get();
    }

    @Override
    public void accept(RemoteCacheConfigurationBuilder builder) {
        String template;
        boolean transactional = (Boolean)this.attributes.attribute(TRANSACTIONAL).get();
        builder.forceReturnValues(false).nearCacheMode(NearCacheMode.DISABLED).transactionMode(transactional ? TransactionMode.NON_XA : TransactionMode.NONE);
        if (transactional) {
            builder.transactionManagerLookup(RemoteTransactionManagerLookup.getInstance());
        }
        if ((template = (String)this.attributes.attribute(TEMPLATE).get()) != null) {
            builder.templateName(template);
        } else {
            builder.configuration((String)this.attributes.attribute(CONFIGURATION).get());
        }
    }

    public String toString() {
        return "HotRodStoreConfiguration{attributes=" + String.valueOf(this.attributes) + "}";
    }

    static enum Element {
        HOTROD_STORE;

    }
}

