/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.remote;

import java.time.Duration;
import java.util.function.Function;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.cache.CacheEntryMutatorFactory;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheEntryMutator;

public class RemoteCacheMutatorFactory<K, V>
implements CacheEntryMutatorFactory<K, V> {
    private final RemoteCache<K, V> cache;
    private final Flag[] flags;
    private final Function<V, Duration> maxIdle;

    public RemoteCacheMutatorFactory(RemoteCache<K, V> cache, Flag[] flags) {
        this(cache, flags, null);
    }

    public RemoteCacheMutatorFactory(RemoteCache<K, V> cache, Flag[] flags, Function<V, Duration> maxIdle) {
        this.cache = cache;
        this.flags = flags;
        this.maxIdle = maxIdle;
    }

    public CacheEntryMutator createMutator(K key, V value) {
        return this.maxIdle != null ? new RemoteCacheEntryMutator<K, V>(this.cache, this.flags, key, value, () -> this.maxIdle.apply(value)) : new RemoteCacheEntryMutator<K, V>(this.cache, this.flags, key, value);
    }
}

