/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.remote;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.junit.jupiter.api.Test;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.wildfly.clustering.cache.infinispan.remote.ReadForUpdateRemoteCache;

public class ReadForUpdateRemoteCacheTestCase {
    @Test
    public void getAsync() {
        RemoteCache ignoreReturnCache = (RemoteCache)Mockito.mock(RemoteCache.class);
        RemoteCache forceReturnCache = (RemoteCache)Mockito.mock(RemoteCache.class);
        UUID key = UUID.randomUUID();
        String expected = "expected";
        ((RemoteCache)Mockito.doReturn((Object)forceReturnCache).when((Object)ignoreReturnCache)).withFlags((Flag[])AdditionalMatchers.aryEq((Object[])new Flag[]{Flag.FORCE_RETURN_VALUE}));
        ((RemoteCache)Mockito.doReturn(CompletableFuture.completedFuture(expected)).when((Object)forceReturnCache)).computeIfPresentAsync((Object)((UUID)ArgumentMatchers.eq((Object)key)), (BiFunction)ArgumentMatchers.same((Object)org.wildfly.clustering.function.BiFunction.latter()), ArgumentMatchers.eq((long)0L), (TimeUnit)((Object)ArgumentMatchers.any()), ArgumentMatchers.eq((long)0L), (TimeUnit)((Object)ArgumentMatchers.any()));
        ReadForUpdateRemoteCache subject = new ReadForUpdateRemoteCache(ignoreReturnCache);
        CompletableFuture result = subject.getAsync((Object)key);
        Assertions.assertThat((CompletableFuture)result).isCompletedWithValue((Object)expected);
    }

    @Test
    public void getAllAsync() {
        RemoteCache ignoreReturnCache = (RemoteCache)Mockito.mock(RemoteCache.class);
        RemoteCache forceReturnCache = (RemoteCache)Mockito.mock(RemoteCache.class);
        UUID existingKey = UUID.randomUUID();
        UUID missingKey = UUID.randomUUID();
        UUID exceptionKey = UUID.randomUUID();
        String expected = "existing";
        Exception exception = new Exception();
        ((RemoteCache)Mockito.doReturn((Object)forceReturnCache).when((Object)ignoreReturnCache)).withFlags((Flag[])AdditionalMatchers.aryEq((Object[])new Flag[]{Flag.FORCE_RETURN_VALUE}));
        ((RemoteCache)Mockito.doReturn(CompletableFuture.completedFuture(expected)).when((Object)forceReturnCache)).computeIfPresentAsync((Object)((UUID)ArgumentMatchers.eq((Object)existingKey)), (BiFunction)ArgumentMatchers.same((Object)org.wildfly.clustering.function.BiFunction.latter()), ArgumentMatchers.eq((long)0L), (TimeUnit)((Object)ArgumentMatchers.any()), ArgumentMatchers.eq((long)0L), (TimeUnit)((Object)ArgumentMatchers.any()));
        ((RemoteCache)Mockito.doReturn(CompletableFuture.completedFuture(null)).when((Object)forceReturnCache)).computeIfPresentAsync((Object)((UUID)ArgumentMatchers.eq((Object)missingKey)), (BiFunction)ArgumentMatchers.same((Object)org.wildfly.clustering.function.BiFunction.latter()), ArgumentMatchers.eq((long)0L), (TimeUnit)((Object)ArgumentMatchers.any()), ArgumentMatchers.eq((long)0L), (TimeUnit)((Object)ArgumentMatchers.any()));
        ReadForUpdateRemoteCache subject = new ReadForUpdateRemoteCache(ignoreReturnCache);
        Assertions.assertThat((CompletableFuture)subject.getAllAsync(Set.of(existingKey, missingKey))).isCompletedWithValue(Map.of(existingKey, expected));
        ((RemoteCache)Mockito.doReturn(CompletableFuture.failedFuture(exception)).when((Object)forceReturnCache)).computeIfPresentAsync((Object)((UUID)ArgumentMatchers.eq((Object)exceptionKey)), (BiFunction)ArgumentMatchers.same((Object)org.wildfly.clustering.function.BiFunction.latter()), ArgumentMatchers.eq((long)0L), (TimeUnit)((Object)ArgumentMatchers.any()), ArgumentMatchers.eq((long)0L), (TimeUnit)((Object)ArgumentMatchers.any()));
        Assertions.assertThat((CompletableFuture)subject.getAllAsync(Set.of(existingKey, missingKey, exceptionKey))).isCompletedExceptionally();
    }
}

