/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.remote;

import java.util.Optional;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfiguration;
import org.wildfly.clustering.cache.CacheProperties;

public class RemoteCacheProperties
implements CacheProperties {
    private final boolean transactional;
    private final boolean cached;

    public RemoteCacheProperties(RemoteCache<?, ?> cache) {
        this.transactional = cache.isTransactional();
        RemoteCacheConfiguration config = (RemoteCacheConfiguration)cache.getRemoteCacheContainer().getConfiguration().remoteCaches().get(cache.getName());
        this.cached = Optional.ofNullable(config).map(RemoteCacheConfiguration::nearCacheMode).orElse(NearCacheMode.DISABLED).enabled();
    }

    public boolean isLockOnRead() {
        return this.transactional && !this.cached;
    }

    public boolean isLockOnWrite() {
        return this.transactional;
    }

    public boolean isMarshalling() {
        return true;
    }

    public boolean isPersistent() {
        return true;
    }

    public boolean isTransactional() {
        return this.transactional;
    }
}

