/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.function;

import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongFunction;

public class Functions {
    private Functions() {
    }

    public static <T, R> Function<T, R> constantFunction(R result) {
        return new ConstantFunction(result);
    }

    public static <R> IntFunction<R> constantIntFunction(R result) {
        return new ConstantFunction(result);
    }

    public static <R> LongFunction<R> constantLongFunction(R result) {
        return new ConstantFunction(result);
    }

    public static <R> DoubleFunction<R> constantDoubleFunction(R result) {
        return new ConstantFunction(result);
    }

    static class ConstantFunction<T, R>
    implements Function<T, R>,
    IntFunction<R>,
    LongFunction<R>,
    DoubleFunction<R> {
        private final R result;

        ConstantFunction(R result) {
            this.result = result;
        }

        @Override
        public R apply(T ignored) {
            return this.result;
        }

        @Override
        public R apply(double value) {
            return this.result;
        }

        @Override
        public R apply(long value) {
            return this.result;
        }

        @Override
        public R apply(int value) {
            return this.result;
        }
    }
}

