/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;

public interface Remover<K> {
    default public void remove(K id) {
        try {
            this.removeAsync(id).toCompletableFuture().get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CancellationException();
        }
    }

    public CompletionStage<Void> removeAsync(K var1);

    default public void purge(K id) {
        try {
            this.purgeAsync(id).toCompletableFuture().get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CancellationException();
        }
    }

    default public CompletionStage<Void> purgeAsync(K id) {
        return this.removeAsync(id);
    }
}

