/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.function;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.wildfly.clustering.cache.function.MapComputeFunction;
import org.wildfly.clustering.cache.function.MapPutFunction;
import org.wildfly.clustering.cache.function.MapRemoveFunction;
import org.wildfly.clustering.cache.function.SetAddFunction;
import org.wildfly.clustering.cache.function.SetRemoveFunction;
import org.wildfly.clustering.marshalling.TesterFactory;
import org.wildfly.clustering.marshalling.junit.TesterFactorySource;

public class FunctionTestCase {
    @Test
    public void set() {
        Set result = (Set)new SetAddFunction((Object)"foo").apply(null, null);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)result).isNotNull()).containsExactly((Object[])new String[]{"foo"});
        Set result2 = (Set)new SetAddFunction((Object)"bar").apply(null, (Object)result);
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)result2).isNotNull()).isNotSameAs((Object)result)).containsExactlyInAnyOrder((Object[])new String[]{"foo", "bar"});
        Set result3 = (Set)new SetAddFunction(Set.of("baz", "qux")).apply(null, (Object)result2);
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)result3).isNotNull()).isNotSameAs((Object)result2)).containsExactlyInAnyOrder((Object[])new String[]{"foo", "bar", "baz", "qux"});
        Set result4 = (Set)new SetRemoveFunction((Object)"foo").apply(null, (Object)result3);
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)result4).isNotNull()).isNotSameAs((Object)result3)).containsExactlyInAnyOrder((Object[])new String[]{"bar", "baz", "qux"});
        Set result5 = (Set)new SetRemoveFunction(Set.of("bar", "baz")).apply(null, (Object)result4);
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)result5).isNotNull()).isNotSameAs((Object)result4)).containsExactly((Object[])new String[]{"qux"});
        Set result6 = (Set)new SetRemoveFunction((Object)"qux").apply(null, (Object)result5);
        Assertions.assertThat((Collection)result6).isNull();
    }

    @Test
    public void map() {
        Map result = (Map)new MapPutFunction((Object)"foo", (Object)"a").apply(null, null);
        ((MapAssert)Assertions.assertThat((Map)result).isNotNull()).containsExactlyEntriesOf(Map.of("foo", "a"));
        Map result2 = (Map)new MapPutFunction((Object)"bar", (Object)"b").apply(null, (Object)result);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)result2).isNotNull()).isNotSameAs((Object)result)).containsExactlyInAnyOrderEntriesOf(Map.of("foo", "a", "bar", "b"));
        Map result3 = (Map)new MapRemoveFunction((Object)"foo").apply(null, (Object)result2);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)result3).isNotNull()).isNotSameAs((Object)result2)).containsExactlyEntriesOf(Map.of("bar", "b"));
        Map result4 = (Map)new MapRemoveFunction((Object)"bar").apply(null, (Object)result3);
        Assertions.assertThat((Map)result4).isNull();
        Map result5 = (Map)new MapComputeFunction(Map.of("foo", "a", "bar", "b")).apply(null, (Object)result4);
        ((MapAssert)Assertions.assertThat((Map)result5).isNotNull()).containsExactlyInAnyOrderEntriesOf(Map.of("foo", "a", "bar", "b"));
        TreeMap<String, String> updates = new TreeMap<String, String>();
        updates.put("foo", null);
        updates.put("bar", "c");
        Map result6 = (Map)new MapComputeFunction(updates).apply(null, (Object)result5);
        ((MapAssert)Assertions.assertThat((Map)result6).isNotNull()).containsExactlyEntriesOf(Map.of("bar", "c"));
        Map result7 = (Map)new MapComputeFunction(Collections.singletonMap("bar", null)).apply(null, (Object)result6);
        Assertions.assertThat((Map)result7).isNull();
    }

    @ParameterizedTest
    @TesterFactorySource
    public void marshalling(TesterFactory factory) {
        factory.createTester().accept((Object)new SetAddFunction(List.of("foo", "bar")));
        factory.createTester().accept((Object)new SetRemoveFunction(List.of("foo", "bar")));
        factory.createTester().accept((Object)new MapPutFunction((Object)"foo", (Object)"bar"));
        factory.createTester().accept((Object)new MapRemoveFunction((Object)"foo"));
        TreeMap<String, String> values = new TreeMap<String, String>();
        values.put("foo", "bar");
        values.put("baz", null);
        factory.createTester().accept((Object)new MapComputeFunction(values));
    }
}

