/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.context.ContextReference;
import org.wildfly.clustering.context.Contextualizer;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;

public class ContextualizerTestCase {
    @Test
    public void test() throws Exception {
        Object original = new Object();
        final Object target = new Object();
        final Object result = new Object();
        final AtomicReference resultRef = new AtomicReference();
        final AtomicContextReference<Object> contextRef = new AtomicContextReference<Object>(original);
        Contextualizer contextualizer = Contextualizer.withContext((Object)target, contextRef);
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                Assertions.assertSame((Object)target, (Object)contextRef.get());
                resultRef.set(result);
            }
        };
        Assertions.assertSame((Object)original, (Object)contextRef.get());
        contextualizer.contextualize(runner).run();
        Assertions.assertSame((Object)original, (Object)contextRef.get());
        Assertions.assertSame((Object)result, resultRef.get());
        resultRef.set(null);
        ExceptionRunnable<Exception> exceptionRunner = new ExceptionRunnable<Exception>(){

            public void run() throws Exception {
                Assertions.assertSame((Object)target, (Object)contextRef.get());
                resultRef.set(result);
            }
        };
        Assertions.assertSame((Object)original, (Object)contextRef.get());
        contextualizer.contextualize((ExceptionRunnable)exceptionRunner).run();
        Assertions.assertSame((Object)original, (Object)contextRef.get());
        Assertions.assertSame((Object)result, resultRef.get());
        resultRef.set(null);
        Callable<Object> caller = new Callable<Object>(){

            @Override
            public Object call() {
                Assertions.assertSame((Object)target, (Object)contextRef.get());
                return result;
            }
        };
        Assertions.assertSame((Object)original, (Object)contextRef.get());
        Assertions.assertSame((Object)result, contextualizer.contextualize((Callable)caller).call());
        Assertions.assertSame((Object)original, (Object)contextRef.get());
        Supplier<Object> supplier = new Supplier<Object>(){

            @Override
            public Object get() {
                Assertions.assertSame((Object)target, (Object)contextRef.get());
                return result;
            }
        };
        Assertions.assertSame((Object)original, (Object)contextRef.get());
        Assertions.assertSame((Object)result, contextualizer.contextualize((Supplier)supplier).get());
        Assertions.assertSame((Object)original, (Object)contextRef.get());
        ExceptionSupplier<Object, Exception> exceptionSupplier = new ExceptionSupplier<Object, Exception>(){

            public Object get() {
                Assertions.assertSame((Object)target, (Object)contextRef.get());
                return result;
            }
        };
        Assertions.assertSame((Object)original, (Object)contextRef.get());
        Assertions.assertSame((Object)result, (Object)contextualizer.contextualize((ExceptionSupplier)exceptionSupplier).get());
        Assertions.assertSame((Object)original, (Object)contextRef.get());
    }

    static class AtomicContextReference<T>
    implements ContextReference<T> {
        private AtomicReference<T> ref;

        AtomicContextReference(T initial) {
            this.ref = new AtomicReference<T>(initial);
        }

        public void accept(T value) {
            this.ref.set(value);
        }

        public T get() {
            return this.ref.get();
        }
    }
}

