/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.wildfly.clustering.context.ContextReference;
import org.wildfly.clustering.context.ContextualExecutor;
import org.wildfly.common.function.ExceptionBiConsumer;
import org.wildfly.common.function.ExceptionBiFunction;
import org.wildfly.common.function.ExceptionConsumer;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;

public interface Contextualizer {
    public static final Contextualizer NONE = new Contextualizer(){

        @Override
        public Runnable contextualize(Runnable runner) {
            return runner;
        }

        @Override
        public <E extends Exception> ExceptionRunnable<E> contextualize(ExceptionRunnable<E> runner) {
            return runner;
        }

        @Override
        public <T> Callable<T> contextualize(Callable<T> caller) {
            return caller;
        }

        @Override
        public <T> Supplier<T> contextualize(Supplier<T> supplier) {
            return supplier;
        }

        @Override
        public <T, E extends Exception> ExceptionSupplier<T, E> contextualize(ExceptionSupplier<T, E> supplier) {
            return supplier;
        }

        @Override
        public <V> Consumer<V> contextualize(Consumer<V> consumer) {
            return consumer;
        }

        @Override
        public <V, E extends Exception> ExceptionConsumer<V, E> contextualize(ExceptionConsumer<V, E> consumer) {
            return consumer;
        }

        @Override
        public <V1, V2> BiConsumer<V1, V2> contextualize(BiConsumer<V1, V2> consumer) {
            return consumer;
        }

        @Override
        public <V1, V2, E extends Exception> ExceptionBiConsumer<V1, V2, E> contextualize(ExceptionBiConsumer<V1, V2, E> consumer) {
            return consumer;
        }

        @Override
        public <V, R> Function<V, R> contextualize(Function<V, R> function) {
            return function;
        }

        @Override
        public <V, R, E extends Exception> ExceptionFunction<V, R, E> contextualize(ExceptionFunction<V, R, E> function) {
            return function;
        }

        @Override
        public <V1, V2, R> BiFunction<V1, V2, R> contextualize(BiFunction<V1, V2, R> function) {
            return function;
        }

        @Override
        public <V1, V2, R, E extends Exception> ExceptionBiFunction<V1, V2, R, E> contextualize(ExceptionBiFunction<V1, V2, R, E> function) {
            return function;
        }
    };

    public Runnable contextualize(Runnable var1);

    public <E extends Exception> ExceptionRunnable<E> contextualize(ExceptionRunnable<E> var1);

    public <T> Callable<T> contextualize(Callable<T> var1);

    public <T> Supplier<T> contextualize(Supplier<T> var1);

    public <T, E extends Exception> ExceptionSupplier<T, E> contextualize(ExceptionSupplier<T, E> var1);

    public <V> Consumer<V> contextualize(Consumer<V> var1);

    public <V, E extends Exception> ExceptionConsumer<V, E> contextualize(ExceptionConsumer<V, E> var1);

    public <V1, V2> BiConsumer<V1, V2> contextualize(BiConsumer<V1, V2> var1);

    public <V1, V2, E extends Exception> ExceptionBiConsumer<V1, V2, E> contextualize(ExceptionBiConsumer<V1, V2, E> var1);

    public <V, R> Function<V, R> contextualize(Function<V, R> var1);

    public <V, R, E extends Exception> ExceptionFunction<V, R, E> contextualize(ExceptionFunction<V, R, E> var1);

    public <V1, V2, R> BiFunction<V1, V2, R> contextualize(BiFunction<V1, V2, R> var1);

    public <V1, V2, R, E extends Exception> ExceptionBiFunction<V1, V2, R, E> contextualize(ExceptionBiFunction<V1, V2, R, E> var1);

    public static <C> Contextualizer withContext(C context, ContextReference<C> reference) {
        final ContextualExecutor executor = ContextualExecutor.withContext(context, reference);
        return new Contextualizer(){

            @Override
            public Runnable contextualize(final Runnable runner) {
                return new Runnable(){

                    @Override
                    public void run() {
                        executor.execute(runner);
                    }
                };
            }

            @Override
            public <E extends Exception> ExceptionRunnable<E> contextualize(final ExceptionRunnable<E> runner) {
                return new ExceptionRunnable<E>(){

                    public void run() throws Exception {
                        executor.execute(runner);
                    }
                };
            }

            @Override
            public <T> Callable<T> contextualize(final Callable<T> caller) {
                return new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        return executor.execute(caller);
                    }
                };
            }

            @Override
            public <T> Supplier<T> contextualize(final Supplier<T> supplier) {
                return new Supplier<T>(){

                    @Override
                    public T get() {
                        return executor.execute(supplier);
                    }
                };
            }

            @Override
            public <T, E extends Exception> ExceptionSupplier<T, E> contextualize(final ExceptionSupplier<T, E> supplier) {
                return new ExceptionSupplier<T, E>(){

                    public T get() throws Exception {
                        return executor.execute(supplier);
                    }
                };
            }

            @Override
            public <V> Consumer<V> contextualize(final Consumer<V> consumer) {
                return new Consumer<V>(){

                    @Override
                    public void accept(V value) {
                        executor.execute(consumer, value);
                    }
                };
            }

            @Override
            public <V, E extends Exception> ExceptionConsumer<V, E> contextualize(final ExceptionConsumer<V, E> consumer) {
                return new ExceptionConsumer<V, E>(){

                    public void accept(V value) throws Exception {
                        executor.execute(consumer, value);
                    }
                };
            }

            @Override
            public <V1, V2> BiConsumer<V1, V2> contextualize(final BiConsumer<V1, V2> consumer) {
                return new BiConsumer<V1, V2>(){

                    @Override
                    public void accept(V1 value1, V2 value2) {
                        executor.execute(consumer, value1, value2);
                    }
                };
            }

            @Override
            public <V1, V2, E extends Exception> ExceptionBiConsumer<V1, V2, E> contextualize(final ExceptionBiConsumer<V1, V2, E> consumer) {
                return new ExceptionBiConsumer<V1, V2, E>(){

                    public void accept(V1 value1, V2 value2) throws Exception {
                        executor.execute(consumer, value1, value2);
                    }
                };
            }

            @Override
            public <V, R> Function<V, R> contextualize(final Function<V, R> function) {
                return new Function<V, R>(){

                    @Override
                    public R apply(V value) {
                        return executor.execute(function, value);
                    }
                };
            }

            @Override
            public <V, R, E extends Exception> ExceptionFunction<V, R, E> contextualize(final ExceptionFunction<V, R, E> function) {
                return new ExceptionFunction<V, R, E>(){

                    public R apply(V value) throws Exception {
                        return executor.execute(function, value);
                    }
                };
            }

            @Override
            public <V1, V2, R> BiFunction<V1, V2, R> contextualize(final BiFunction<V1, V2, R> function) {
                return new BiFunction<V1, V2, R>(){

                    @Override
                    public R apply(V1 value1, V2 value2) {
                        return executor.execute(function, value1, value2);
                    }
                };
            }

            @Override
            public <V1, V2, R, E extends Exception> ExceptionBiFunction<V1, V2, R, E> contextualize(final ExceptionBiFunction<V1, V2, R, E> function) {
                return new ExceptionBiFunction<V1, V2, R, E>(){

                    public R apply(V1 value1, V2 value2) throws Exception {
                        return executor.execute(function, value1, value2);
                    }
                };
            }
        };
    }

    public static Contextualizer composite(final List<Contextualizer> contextualizers) {
        return new Contextualizer(){

            @Override
            public Runnable contextualize(Runnable runner) {
                Runnable result = runner;
                for (Contextualizer contextualizer : contextualizers) {
                    result = contextualizer.contextualize(result);
                }
                return result;
            }

            @Override
            public <E extends Exception> ExceptionRunnable<E> contextualize(ExceptionRunnable<E> runner) {
                ExceptionRunnable<E> result = runner;
                for (Contextualizer contextualizer : contextualizers) {
                    result = contextualizer.contextualize(result);
                }
                return result;
            }

            @Override
            public <T> Callable<T> contextualize(Callable<T> caller) {
                Callable<T> result = caller;
                for (Contextualizer contextualizer : contextualizers) {
                    result = contextualizer.contextualize(result);
                }
                return result;
            }

            @Override
            public <T> Supplier<T> contextualize(Supplier<T> supplier) {
                Supplier<T> result = supplier;
                for (Contextualizer contextualizer : contextualizers) {
                    result = contextualizer.contextualize(result);
                }
                return result;
            }

            @Override
            public <T, E extends Exception> ExceptionSupplier<T, E> contextualize(ExceptionSupplier<T, E> supplier) {
                ExceptionSupplier<T, E> result = supplier;
                for (Contextualizer contextualizer : contextualizers) {
                    result = contextualizer.contextualize(result);
                }
                return result;
            }

            @Override
            public <V> Consumer<V> contextualize(Consumer<V> consumer) {
                Consumer<V> result = consumer;
                for (Contextualizer contextualizer : contextualizers) {
                    result = contextualizer.contextualize(result);
                }
                return result;
            }

            @Override
            public <V, E extends Exception> ExceptionConsumer<V, E> contextualize(ExceptionConsumer<V, E> consumer) {
                ExceptionConsumer<V, E> result = consumer;
                for (Contextualizer contextualizer : contextualizers) {
                    result = contextualizer.contextualize(result);
                }
                return result;
            }

            @Override
            public <V1, V2> BiConsumer<V1, V2> contextualize(BiConsumer<V1, V2> consumer) {
                BiConsumer<V1, V2> result = consumer;
                for (Contextualizer contextualizer : contextualizers) {
                    result = contextualizer.contextualize(result);
                }
                return result;
            }

            @Override
            public <V1, V2, E extends Exception> ExceptionBiConsumer<V1, V2, E> contextualize(ExceptionBiConsumer<V1, V2, E> consumer) {
                ExceptionBiConsumer<V1, V2, E> result = consumer;
                for (Contextualizer contextualizer : contextualizers) {
                    result = contextualizer.contextualize(result);
                }
                return result;
            }

            @Override
            public <V, R> Function<V, R> contextualize(Function<V, R> function) {
                Function<V, R> result = function;
                for (Contextualizer contextualizer : contextualizers) {
                    result = contextualizer.contextualize(result);
                }
                return result;
            }

            @Override
            public <V, R, E extends Exception> ExceptionFunction<V, R, E> contextualize(ExceptionFunction<V, R, E> function) {
                ExceptionFunction<V, R, E> result = function;
                for (Contextualizer contextualizer : contextualizers) {
                    result = contextualizer.contextualize(result);
                }
                return result;
            }

            @Override
            public <V1, V2, R> BiFunction<V1, V2, R> contextualize(BiFunction<V1, V2, R> function) {
                BiFunction<V1, V2, R> result = function;
                for (Contextualizer contextualizer : contextualizers) {
                    result = contextualizer.contextualize(result);
                }
                return result;
            }

            @Override
            public <V1, V2, R, E extends Exception> ExceptionBiFunction<V1, V2, R, E> contextualize(ExceptionBiFunction<V1, V2, R, E> function) {
                ExceptionBiFunction<V1, V2, R, E> result = function;
                for (Contextualizer contextualizer : contextualizers) {
                    result = contextualizer.contextualize(result);
                }
                return result;
            }
        };
    }
}

