/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import org.wildfly.clustering.context.ContextClassLoaderReference;
import org.wildfly.clustering.context.ContextualThreadFactory;
import org.wildfly.clustering.context.Reflect;

public class DefaultThreadFactory
extends ContextualThreadFactory<ClassLoader> {
    public DefaultThreadFactory(Class<?> targetClass) {
        this(targetClass, () -> new ThreadGroup(targetClass.getSimpleName()));
    }

    public DefaultThreadFactory(Class<?> targetClass, Supplier<ThreadGroup> threadGroup) {
        this(Reflect.createThreadFactory(threadGroup), targetClass);
    }

    public DefaultThreadFactory(ThreadFactory factory) {
        this(factory, factory.getClass());
    }

    private DefaultThreadFactory(ThreadFactory factory, Class<?> targetClass) {
        super(factory, Reflect.getClassLoader(targetClass), ContextClassLoaderReference.INSTANCE);
    }
}

