/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.wildfly.clustering.context.ContextReference;
import org.wildfly.common.function.ExceptionBiConsumer;
import org.wildfly.common.function.ExceptionBiFunction;
import org.wildfly.common.function.ExceptionConsumer;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;

public interface ContextualExecutor
extends Executor {
    @Override
    default public void execute(Runnable runner) {
        ExceptionRunnable r = runner::run;
        this.execute(r);
    }

    public <E extends Exception> void execute(ExceptionRunnable<E> var1) throws E;

    default public <V> void execute(Consumer<V> consumer, V value) {
        ExceptionConsumer c = consumer::accept;
        this.execute(c, value);
    }

    public <V, E extends Exception> void execute(ExceptionConsumer<V, E> var1, V var2) throws E;

    default public <V1, V2> void execute(BiConsumer<V1, V2> consumer, V1 value1, V2 value2) {
        ExceptionBiConsumer c = consumer::accept;
        this.execute(c, value1, value2);
    }

    public <T, V, E extends Exception> void execute(ExceptionBiConsumer<T, V, E> var1, T var2, V var3) throws E;

    default public <T> T execute(Callable<T> caller) throws Exception {
        ExceptionSupplier supplier = caller::call;
        return this.execute(supplier);
    }

    default public <T> T execute(Supplier<T> supplier) {
        ExceptionSupplier s = supplier::get;
        return this.execute(s);
    }

    public <T, E extends Exception> T execute(ExceptionSupplier<T, E> var1) throws E;

    default public <V, R> R execute(Function<V, R> function, V value) {
        ExceptionFunction f = function::apply;
        return this.execute(f, value);
    }

    public <V, R, E extends Exception> R execute(ExceptionFunction<V, R, E> var1, V var2) throws E;

    default public <V1, V2, R> R execute(BiFunction<V1, V2, R> function, V1 value1, V2 value2) {
        ExceptionBiFunction f = function::apply;
        return this.execute(f, value1, value2);
    }

    public <V1, V2, R, E extends Exception> R execute(ExceptionBiFunction<V1, V2, R, E> var1, V1 var2, V2 var3) throws E;

    public static <C> ContextualExecutor withContext(final C context, final ContextReference<C> reference) {
        return new ContextualExecutor(){

            @Override
            public <E extends Exception> void execute(ExceptionRunnable<E> runner) throws E {
                Object currentContext = reference.get();
                reference.accept(context);
                try {
                    runner.run();
                }
                finally {
                    reference.accept(currentContext);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T, E extends Exception> T execute(ExceptionSupplier<T, E> supplier) throws E {
                Object currentContext = reference.get();
                reference.accept(context);
                try {
                    Object object = supplier.get();
                    return (T)object;
                }
                finally {
                    reference.accept(currentContext);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <T, E extends Exception> void execute(ExceptionConsumer<T, E> consumer, T value) throws E {
                Object currentContext = reference.get();
                reference.accept(context);
                try {
                    consumer.accept(value);
                }
                finally {
                    reference.accept(currentContext);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T, V, E extends Exception> void execute(ExceptionBiConsumer<T, V, E> consumer, T value1, V value2) throws E {
                Object currentContext = reference.get();
                reference.accept(context);
                try {
                    consumer.accept(value1, value2);
                }
                finally {
                    reference.accept(currentContext);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <T, R, E extends Exception> R execute(ExceptionFunction<T, R, E> function, T value) throws E {
                Object currentContext = reference.get();
                reference.accept(context);
                try {
                    Object object = function.apply(value);
                    return (R)object;
                }
                finally {
                    reference.accept(currentContext);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <V1, V2, R, E extends Exception> R execute(ExceptionBiFunction<V1, V2, R, E> function, V1 value1, V2 value2) throws E {
                Object currentContext = reference.get();
                reference.accept(context);
                try {
                    Object object = function.apply(value1, value2);
                    return (R)object;
                }
                finally {
                    reference.accept(currentContext);
                }
            }
        };
    }
}

