/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.wildfly.clustering.context.ContextClassLoaderReference;
import org.wildfly.clustering.context.Contextualizer;
import org.wildfly.clustering.context.ContextualizerFactory;
import org.wildfly.clustering.context.Reflect;

public enum DefaultContextualizerFactory implements ContextualizerFactory
{
    INSTANCE;

    private final List<ContextualizerFactory> factories = new LinkedList<ContextualizerFactory>();

    private DefaultContextualizerFactory() {
        this.factories.add(new ContextualizerFactory(){

            @Override
            public Contextualizer createContextualizer(ClassLoader loader) {
                return Contextualizer.withContext(loader, ContextClassLoaderReference.INSTANCE);
            }
        });
        Reflect.load(ContextualizerFactory.class, this.factories::add);
    }

    @Override
    public Contextualizer createContextualizer(ClassLoader loader) {
        ArrayList<Contextualizer> contextualizers = new ArrayList<Contextualizer>(this.factories.size());
        for (ContextualizerFactory factory : this.factories) {
            contextualizers.add(factory.createContextualizer(loader));
        }
        return Contextualizer.composite(contextualizers);
    }
}

