/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.wildfly.clustering.context.ThreadContextReference;

public enum ContextClassLoaderReference implements ThreadContextReference<ClassLoader>
{
    INSTANCE;


    @Override
    public ClassLoader apply(final Thread thread) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return thread.getContextClassLoader();
            }
        });
    }

    @Override
    public void accept(final Thread thread, final ClassLoader loader) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Void run() {
                thread.setContextClassLoader(loader);
                return null;
            }
        });
    }
}

