/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ExecutorServiceFactory implements Function<ThreadFactory, ExecutorService>
{
    SINGLE_THREAD{

        @Override
        public ExecutorService apply(ThreadFactory factory) {
            return Executors.newSingleThreadExecutor(factory);
        }
    }
    ,
    CACHED_THREAD{

        @Override
        public ExecutorService apply(ThreadFactory factory) {
            return Executors.newCachedThreadPool(factory);
        }
    };

}

